/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.macro;

import io.probedock.maven.plugin.glassfish.command.CommandExecutor;
import io.probedock.maven.plugin.glassfish.macro.IMacroCommand;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractMacro {
    protected Configuration configuration;
    private final List<IMacroCommand> commands = new ArrayList<IMacroCommand>();

    public AbstractMacro(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(CommandExecutor executor) throws MojoExecutionException, MojoFailureException {
        for (IMacroCommand macroCommand : this.commands) {
            this.configuration.getLog().info((CharSequence)("*****> " + macroCommand.getDescriptionText() + " <*****"));
            macroCommand.execute(executor);
        }
    }

    protected void registerCommand(IMacroCommand macroCommand) {
        if (macroCommand != null) {
            this.commands.add(macroCommand);
        }
    }

    protected boolean isLocalDomain() {
        return this.configuration.isLocalDomain();
    }
}

