/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.command.argument;

import io.probedock.maven.plugin.glassfish.command.argument.Argument;
import io.probedock.maven.plugin.glassfish.command.argument.CommandArgumentName;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import io.probedock.maven.plugin.glassfish.model.Property;
import java.util.HashSet;
import java.util.Set;

public class CommandArgumentFactory {
    public static Argument<CommandArgumentName> buildStringArgument(CommandArgumentName name, String value) {
        if (value != null && !value.isEmpty()) {
            return CommandArgumentFactory.create(name).setValue(value);
        }
        return null;
    }

    public static Argument<CommandArgumentName> buildIntegerArgument(CommandArgumentName name, Integer value) {
        if (value != null) {
            return CommandArgumentFactory.create(name).setValue(value);
        }
        return null;
    }

    public static Argument<CommandArgumentName> buildBooleanArgument(CommandArgumentName name, Boolean value) {
        if (value != null) {
            return CommandArgumentFactory.create(name).setValue(value);
        }
        return null;
    }

    public static Argument<CommandArgumentName> buildAdminPortArgument(Configuration configuration) {
        return CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.ADMIN_PORT, configuration.getDomain().getAdminPort());
    }

    public static Argument<CommandArgumentName> buildDebugArgument(Configuration configuration) {
        return CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEBUG, configuration.getGlassfish().isDebug());
    }

    public static Argument<CommandArgumentName> buildDomainDirectoryArgument(Configuration configuration) {
        return CommandArgumentFactory.buildStringArgument(CommandArgumentName.DOMAIN_DIRECTORY, configuration.getDomain().getDirectory().getAbsolutePath());
    }

    public static Argument<CommandArgumentName> buildDomainNameArgument(Configuration configuration) {
        return CommandArgumentFactory.buildStringArgument(CommandArgumentName.DOMAIN_NAME, configuration.getDomain().getName());
    }

    public static Argument<CommandArgumentName> buildDomainPropertiesArgument(Configuration configuration) {
        HashSet<Property> domainProperties = new HashSet<Property>();
        CommandArgumentFactory.addPortAsProperty(domainProperties, "http.ssl.port", configuration.getDomain().getHttpsPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "orb.listener.port", configuration.getDomain().getIiopPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "jms.port", configuration.getDomain().getJmsPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "domain.jmxPort", configuration.getDomain().getJmxPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "orb.ssl.port", configuration.getDomain().getIiopsPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "orb.mutualauth.port", configuration.getDomain().getIiopsmPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "java.debugger.port", configuration.getDomain().getDebuggerPort());
        CommandArgumentFactory.addPortAsProperty(domainProperties, "osgi.shell.telnet.port", configuration.getDomain().getOsgiShellTelnetPort());
        return CommandArgumentFactory.create(CommandArgumentName.DOMAIN_PROPERTIES).setPropertiesValue(domainProperties);
    }

    public static Argument<CommandArgumentName> buildInstancePortArgument(Configuration configuration) {
        return CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.INSTANCE_PORT, configuration.getDomain().getHttpPort());
    }

    public static Argument<CommandArgumentName> buildJvmOptionsArgument(Set<String> jvmOptions) {
        return CommandArgumentFactory.create(CommandArgumentName.JVM_OPTIONS).setStringsValue(jvmOptions);
    }

    public static Argument<CommandArgumentName> buildPropertyWithoutNameArgument(Set<Property> properties) {
        return CommandArgumentFactory.buildPropertiesArgument(CommandArgumentName.EMPTY_NAME_PROPERTY, properties);
    }

    public static Argument<CommandArgumentName> buildPropertyArgument(Set<Property> properties) {
        return CommandArgumentFactory.buildPropertiesArgument(CommandArgumentName.PROPERTY, properties);
    }

    public static Argument<CommandArgumentName> buildSetAttributeArgument(Property property) {
        HashSet<Property> props = new HashSet<Property>();
        props.add(property);
        return CommandArgumentFactory.buildPropertiesArgument(CommandArgumentName.SET_ATTRIBUTE, props);
    }

    public static Argument<CommandArgumentName> buildDeploymentPropertyArgument(Set<Property> properties) {
        return CommandArgumentFactory.buildPropertiesArgument(CommandArgumentName.DEP_PROPERTY, properties);
    }

    private static Argument<CommandArgumentName> create(CommandArgumentName name) {
        if (name == null) {
            throw new IllegalArgumentException("The name must not be null.");
        }
        return new Argument<CommandArgumentName>(name);
    }

    private static void addPortAsProperty(Set<Property> properties, String name, int port) {
        if (port > 0 && port < 65536) {
            properties.add(new Property(name, "" + port));
        }
    }

    private static Argument<CommandArgumentName> buildPropertiesArgument(CommandArgumentName name, Set<Property> properties) {
        if (properties != null && !properties.isEmpty()) {
            return CommandArgumentFactory.create(name).setPropertiesValue(properties);
        }
        return null;
    }
}

