/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.command.argument;

import io.probedock.maven.plugin.glassfish.command.argument.Argument;
import io.probedock.maven.plugin.glassfish.command.argument.IArgumentName;
import io.probedock.maven.plugin.glassfish.model.Configuration;

public enum AsadminArgumentName implements IArgumentName
{
    ECHO("echo", true),
    HOST("host"){

        public Argument create(Configuration configuration) {
            return this.create().setValue(configuration.getDomain().getHost());
        }
    }
    ,
    INTERACTIVE("interactive", "false", true),
    PASSWORDFILE("passwordfile"){

        public Argument create(Configuration configuration) {
            return super.create().setValue(configuration.getGlassfish().getPasswordFile());
        }
    }
    ,
    PORT("port"){

        public Argument create(Configuration configuration) {
            return this.create().setValue(configuration.getDomain().getAdminPort());
        }
    }
    ,
    TERSE("terse", true){

        public Argument create(Configuration configuration) {
            return super.create().setValue(configuration.getGlassfish().isTerse());
        }
    }
    ,
    USER("user"){

        public Argument create(Configuration configuration) {
            return super.create().setValue(configuration.getGlassfish().getUser());
        }
    };

    private boolean isBoolean = false;
    private String argName;
    private String defaultValue = null;

    private AsadminArgumentName(String argName) {
        this.argName = argName;
    }

    private AsadminArgumentName(String argName, String defaultValue) {
        this(argName);
        this.defaultValue = defaultValue;
    }

    private AsadminArgumentName(String argName, String defaultValue, boolean isBoolean) {
        this(argName, defaultValue);
        this.isBoolean = isBoolean;
    }

    private AsadminArgumentName(String argName, boolean isBoolean) {
        this(argName, null, isBoolean);
    }

    @Override
    public String getArgName() {
        return this.argName;
    }

    @Override
    public boolean isBoolean() {
        return this.isBoolean;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Argument<AsadminArgumentName> create() {
        return new Argument<AsadminArgumentName>(this);
    }

    public Argument<AsadminArgumentName> create(Configuration configuration) {
        return this.create();
    }
}

