/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.command.argument;

import io.probedock.maven.plugin.glassfish.command.argument.IArgumentName;
import io.probedock.maven.plugin.glassfish.model.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Argument<Name extends IArgumentName> {
    private static final String ARG_SUFFIX = "--";
    private static final String ARG_EQUAL = "=";
    private Name name;
    private String value;

    public Argument(Name name) {
        this.name = name;
    }

    public IArgumentName getName() {
        return this.name;
    }

    public Argument setValue(String value) {
        this.value = value;
        return this;
    }

    public Argument setValue(boolean value) {
        this.value = "" + value;
        return this;
    }

    public Argument setValue(int value) {
        this.value = "" + value;
        return this;
    }

    public Argument setPropertiesValue(Set<Property> value) {
        this.value = Argument.formatProperties(value);
        return this;
    }

    public Argument setStringsValue(Set<String> value) {
        this.value = Argument.formatStrings(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> buildArgument() {
        ArrayList<String> elements = new ArrayList<String>();
        if (this.name.getArgName() == null) {
            if (this.value == null) {
                if (this.name.getDefaultValue() == null) throw new IllegalArgumentException("You must provide a value or a default value for an argument without a name.");
                elements.add(this.name.getDefaultValue());
                return elements;
            } else {
                elements.add(this.value);
            }
            return elements;
        } else if (this.value == null) {
            if (this.name.getDefaultValue() != null) {
                if (this.name.isBoolean()) {
                    elements.add(ARG_SUFFIX + this.name.getArgName() + ARG_EQUAL + this.name.getDefaultValue());
                    return elements;
                } else {
                    elements.add(ARG_SUFFIX + this.name.getArgName());
                    elements.add(this.name.getDefaultValue());
                }
                return elements;
            } else {
                elements.add(ARG_SUFFIX + this.name.getArgName());
            }
            return elements;
        } else if (this.name.isBoolean()) {
            elements.add(ARG_SUFFIX + this.name.getArgName() + ARG_EQUAL + this.value);
            return elements;
        } else {
            elements.add(ARG_SUFFIX + this.name.getArgName());
            elements.add(this.value);
        }
        return elements;
    }

    private static String escape(String value, String chars) {
        return Argument.escape(value, chars, "\\\\");
    }

    private static String escape(String value, String chars, String escapeSequence) {
        String escaped = value;
        if (escaped == null) {
            return "";
        }
        for (char ch : chars.toCharArray()) {
            escaped = escaped.replaceAll(String.valueOf(ch), escapeSequence + ch);
        }
        return escaped;
    }

    private static String formatProperties(Set<Property> objectProperties) {
        if (objectProperties != null && !objectProperties.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Property property : objectProperties) {
                sb.append(':').append(Argument.escape(property.getName(), "=;:")).append(ARG_EQUAL).append(Argument.escape(property.getValue(), "=;:"));
            }
            return sb.substring(1);
        }
        return "";
    }

    private static String formatStrings(Set<String> strings) {
        if (strings != null && !strings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String str : strings) {
                sb.append(':').append(Argument.escape(str, "=;:"));
            }
            return sb.substring(1);
        }
        return "";
    }
}

