/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.command;

import io.probedock.maven.plugin.glassfish.command.CommandBuilder;
import io.probedock.maven.plugin.glassfish.command.CommandName;
import io.probedock.maven.plugin.glassfish.command.argument.CommandArgumentFactory;
import io.probedock.maven.plugin.glassfish.command.argument.CommandArgumentName;
import io.probedock.maven.plugin.glassfish.model.AdminObject;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import io.probedock.maven.plugin.glassfish.model.ConnectionFactory;
import io.probedock.maven.plugin.glassfish.model.ConnectorConnectionPool;
import io.probedock.maven.plugin.glassfish.model.ConnectorResource;
import io.probedock.maven.plugin.glassfish.model.DeployConfiguration;
import io.probedock.maven.plugin.glassfish.model.JdbcResource;
import io.probedock.maven.plugin.glassfish.model.JmsHost;
import io.probedock.maven.plugin.glassfish.model.JmsResource;
import io.probedock.maven.plugin.glassfish.model.Property;
import io.probedock.maven.plugin.glassfish.model.RedeployConfiguration;
import io.probedock.maven.plugin.glassfish.model.ResourceAdapter;
import java.util.HashSet;
import java.util.Set;

public class CommandFactory {
    public static CommandBuilder buildCreateDomainCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.CREATE_DOMAIN, configuration).addArgument(CommandArgumentFactory.buildAdminPortArgument(configuration)).addArgument(CommandArgumentFactory.buildInstancePortArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainDirectoryArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainPropertiesArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainNameArgument(configuration)).setFriendlyErrorMessage("Unable to create the domain.");
    }

    public static CommandBuilder buildCreatJdbcConnectionPool(Configuration configuration, JdbcResource resource) {
        Set<Property> properties;
        String description = resource.getPoolDescription();
        if (description == null) {
            description = "Connection pool for " + resource.getJndiName().replace("jdbc/", "");
        }
        if ((properties = resource.getProperties()) == null) {
            properties = new HashSet<Property>();
        }
        if (resource.getUser() != null) {
            properties.add(new Property("User", resource.getUser()));
        }
        if (resource.getPassword() != null) {
            properties.add(new Property("Password", resource.getPassword()));
        }
        if (resource.getUrl() != null) {
            properties.add(new Property("Url", resource.getUrl()));
        }
        return CommandFactory.create(CommandName.CREATE_JDBC_CONNECTION_POOL, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_DATA_SOURCE_CLASS_NAME, resource.getDataSourceClassName())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.RESOURCE_TYPE, resource.getType())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_STEADY_POOL_SIZE, resource.getSteadyPoolSize())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_MAX_POOL_SIZE, resource.getMaxPoolSize())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_MAX_WAIT, resource.getMaxWait())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_POOL_RESIZE, resource.getPoolResize())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_IDLE_TIMEOUT, resource.getIdleTimeout())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_INIT_SQL, resource.getInitSql())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_ISOLATION_LEVEL, resource.getIsolationLevel())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_ISOLATION_GUARANTEED, resource.getIsolationGuaranteed())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_IS_CONNECTION_VALIDATION_REQUIRED, resource.getIsConnectValidateReq())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_VALIDATION_METHOD, resource.getValidationMethod())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_VALIDATION_TABLE, resource.getValidationTable())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_FAIL_CONNECTION, resource.getFailConnection())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_ALLOW_NON_COMPONENT_CALLERS, resource.getAllowNonComponentCallers())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_NON_TRANSACTIONAL_CONNECTIONS, resource.getNonTransactionalConnections())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_VALIDATE_AT_MOST_ONCE_PERIOD, resource.getValidateAtMostOncePeriod())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_LEAK_TIMEOUT, resource.getLeakTimeout())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_LEAK_RECLAIM, resource.getLeakReclaim())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_STATEMENT_LEAK_TIMEOUT, resource.getStatementLeakTimeout())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_STATEMENT_LEAK_RECLAIM, resource.getStatementLeakReclaim())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_CREATION_RETRY_ATTEMPTS, resource.getCreationRetryAttempts())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_CREATION_INTERVAL, resource.getCreationRetryInterval())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_SQL_TRACE_LISTENERS, resource.getSqlTraceListeners())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_STATEMENT_TIMEOUT, resource.getStatementTimeout())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_LAZY_CONNECTION_ENLISTMENT, resource.getLazyConnectionEnlistment())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_LAZY_CONNECTION_ASSOCIATION, resource.getLazyConnectionAssociation())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_ASSOCIATE_WITH_THREAD, resource.getAssociateWithThread())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_DRIVER_CLASS_NAME, resource.getDriverClassName())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_MATCH_CONNECTIONS, resource.getMatchConnections())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_MAX_CONNECTION_USAGE_COUNT, resource.getMaxConnectionUsageCount())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_PING, resource.getPing())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_POOLING, resource.getPooling())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JDBC_STATEMENT_CACHE_SIZE, resource.getStatementCacheSize())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_VALIDATION_CLASS_NAME, resource.getValidationClassName())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.JDBC_WRAP_JDBC_OBJECTS, resource.getWrapJdbcObjects())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DESCRIPTION, description)).addArgument(CommandArgumentFactory.buildPropertyArgument(properties)).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, resource.getPoolId())).setFriendlyErrorMessage("Unable to create the JDBC connection pool [" + resource.getJndiName() + "].");
    }

    public static CommandBuilder buildCreateJdbcResource(Configuration configuration, JdbcResource resource) {
        String description = resource.getDescription();
        if (description == null) {
            description = "JDBC resource for " + resource.getJndiName().replace("jdbc/", "");
        }
        return CommandFactory.create(CommandName.CREATE_JDBC_RESOURCE, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JDBC_CONNECTION_POOL_ID, resource.getPoolId())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DESCRIPTION, description)).addArgument(CommandArgumentFactory.buildPropertyArgument(resource.getPoolProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, resource.getJndiName())).setFriendlyErrorMessage("Unable to create the JDBC resource [" + resource.getJndiName() + "].");
    }

    public static CommandBuilder buildSetTimerResourceConnectionPool(Configuration configuration, JdbcResource resource) {
        Property property = new Property("domain.resources.jdbc-resource.jdbc/__TimerPool.pool-name", resource.getPoolId());
        return CommandFactory.buildSetCommand(configuration, property);
    }

    public static CommandBuilder buildCreateJmsHostCommand(Configuration configuration, JmsHost jmsHost) {
        return CommandFactory.create(CommandName.CREATE_JMS_HOST, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_HOST_MQHOST, jmsHost.getMqHost())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.JMS_HOST_MQPORT, jmsHost.getMqPort())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_HOST_MQUSER, jmsHost.getMqUser())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_HOST_MQPASSWORD, jmsHost.getMqPassword())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_HOST_NAME, jmsHost.getName())).setFriendlyErrorMessage("Unable to create the JMS Host [" + jmsHost.getName() + "]");
    }

    public static CommandBuilder buildCreateJmsDestination(Configuration configuration, JmsResource resource) {
        String name = resource.getName();
        if (name == null) {
            name = resource.getJndiName().replace("jms/", "");
        }
        return CommandFactory.create(CommandName.CREATE_JMS_DESTINATION, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_DESTINATION_TYPE, resource.getType().name().toLowerCase())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_DESTINATION_NAME, name)).setFriendlyErrorMessage("Unable to create physical destionation [" + name + "].");
    }

    public static CommandBuilder buildCreateJmsResourceCommand(Configuration configuration, ConnectionFactory connectionFactory) {
        Set<Property> properties;
        String jndiName = connectionFactory.getJndiName();
        String description = connectionFactory.getDescription();
        if (description == null) {
            description = jndiName.replace("jms/", "");
        }
        if ((properties = connectionFactory.getProperties()) == null) {
            properties = new HashSet<Property>();
        }
        if (connectionFactory.getUser() != null) {
            properties.add(new Property("UserName", connectionFactory.getUser()));
        }
        if (connectionFactory.getPassword() != null) {
            properties.add(new Property("Password", connectionFactory.getPassword()));
        }
        if (connectionFactory.getAddressList() != null) {
            properties.add(new Property("AddressList", connectionFactory.getAddressList()));
        }
        return CommandFactory.create(CommandName.CREATE_JMS_RESOURCE, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.RESOURCE_TYPE, connectionFactory.getType().getClazz())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DESCRIPTION, description)).addArgument(CommandArgumentFactory.buildPropertyArgument(properties)).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, jndiName)).setFriendlyErrorMessage("Unable to create the JMS resource [" + connectionFactory.getJndiName() + "].");
    }

    public static CommandBuilder buildCreateJmsResourceCommand(Configuration configuration, JmsResource resource) {
        Set<Property> properties;
        String description;
        String jndiName = resource.getJndiName();
        String name = resource.getName();
        if (name == null) {
            name = jndiName.replace("jms/", "");
        }
        if ((description = resource.getDescription()) == null) {
            description = name;
        }
        if ((properties = resource.getProperties()) == null) {
            properties = new HashSet<Property>();
        }
        properties.add(new Property("Name", name));
        return CommandFactory.create(CommandName.CREATE_JMS_RESOURCE, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.RESOURCE_TYPE, resource.getType().getClazz())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DESCRIPTION, description)).addArgument(CommandArgumentFactory.buildPropertyArgument(properties)).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, jndiName)).setFriendlyErrorMessage("Unable to create the JMS resource [" + resource.getJndiName() + "].");
    }

    public static CommandBuilder buildCreateJvmOptionsCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.CREATE_JVM_OPTIONS, configuration).addArgument(CommandArgumentFactory.buildJvmOptionsArgument(configuration.getDomain().getCreateJvmOptions())).setFriendlyErrorMessage("Unable to create JVM options.");
    }

    public static CommandBuilder buildDeleteDefaultJmsHost(Configuration configuration) {
        return CommandFactory.create(CommandName.DELETE_JMS_HOST, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JMS_HOST_NAME, "default_JMS_host")).setFriendlyErrorMessage("Unable to delete the default JMS host [default_JMS_host]");
    }

    public static CommandBuilder buildDeleteDomainCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.DELETE_DOMAIN, configuration).addArgument(CommandArgumentFactory.buildDomainDirectoryArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainNameArgument(configuration)).setFriendlyErrorMessage("Unable to delete the domain.");
    }

    public static CommandBuilder buildDeleteJvmOptionsCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.DELETE_JVM_OPTIONS, configuration).addArgument(CommandArgumentFactory.buildJvmOptionsArgument(configuration.getDomain().getDeleteJvmOption())).setFriendlyErrorMessage("Unable to delete JVM options.");
    }

    public static CommandBuilder buildDeployCommand(Configuration configuration, DeployConfiguration deployConfig) {
        return CommandFactory.create(CommandName.DEPLOY, configuration).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_FORCE, deployConfig.getForce())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_VIRTUAL_SERVERS, deployConfig.getVirtualServers())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_CONTEXT_ROOT, deployConfig.getContextRoot())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_PRE_COMPILE_JSP, deployConfig.getPreCompileJsp())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_VERIFY, deployConfig.getVerify())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_NAME, deployConfig.getName())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_UPLOAD, deployConfig.getUpload())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_RETRIEVE, deployConfig.getRetrieve())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_DB_VENDOR_NAME, deployConfig.getDbVendorName())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_CREATE_TABLES, deployConfig.getCreateTables())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_DROP_AND_CREATE_TABLES, deployConfig.getDropAndCreateTables())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_UNIQUE_TABLE_NAMES, deployConfig.getUniqueTableNames())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_DEPLOYMENT_PLAN, deployConfig.getDeploymentPlan())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_ALTDD, deployConfig.getAltdd())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_RUNTIME_ATLDD, deployConfig.getRuntimeAltdd())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.DEP_DEPLOYMENT_ORDER, deployConfig.getDeploymentOrder())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_ENABLED, deployConfig.getEnabled())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_GENERATE_RMI_STUBS, deployConfig.getGenerateRmiStubs())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_AVAILABILITY_ENABLED, deployConfig.getAvailabilityEnabled())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_ASYNCHRONOUS_REPLICATION, deployConfig.getAsynReplication())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_LOAD_BALANCING_ENABLED, deployConfig.getLenabled())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_KEEP_STATE, deployConfig.getKeepState())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_LIBRARIES, deployConfig.getLibraries())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_TYPE, deployConfig.getType())).addArgument(CommandArgumentFactory.buildDeploymentPropertyArgument(deployConfig.getProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_FILE, deployConfig.getFile())).setFriendlyErrorMessage("Unable to deploy the component.");
    }

    public static CommandBuilder buildDeployCommand(Configuration configuration) {
        return CommandFactory.buildDeployCommand(configuration, configuration.getDeployConfiguration());
    }

    public static CommandBuilder buildRedeployCommand(Configuration configuration) {
        RedeployConfiguration redepConfig = configuration.getRedeployConfiguration();
        return CommandFactory.create(CommandName.DEPLOY, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_NAME, redepConfig.getName())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_UPLOAD, redepConfig.getUpload())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_RETRIEVE, redepConfig.getRetrieve())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_DB_VENDOR_NAME, redepConfig.getDbVendorName())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_CREATE_TABLES, redepConfig.getCreateTables())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_DROP_AND_CREATE_TABLES, redepConfig.getDropAndCreateTables())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_UNIQUE_TABLE_NAMES, redepConfig.getUniqueTableNames())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_DEPLOYMENT_PLAN, redepConfig.getDeploymentPlan())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_ALTDD, redepConfig.getAltdd())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_RUNTIME_ATLDD, redepConfig.getRuntimeAltdd())).addArgument(CommandArgumentFactory.buildIntegerArgument(CommandArgumentName.DEP_DEPLOYMENT_ORDER, redepConfig.getDeploymentOrder())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_ENABLED, redepConfig.getEnabled())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_GENERATE_RMI_STUBS, redepConfig.getGenerateRmiStubs())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_CONTEXT_ROOT, redepConfig.getContextRoot())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_PRE_COMPILE_JSP, redepConfig.getPreCompileJsp())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_VERIFY, redepConfig.getVerify())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_VIRTUAL_SERVERS, redepConfig.getVirtualServers())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_AVAILABILITY_ENABLED, redepConfig.getAvailabilityEnabled())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_ASYNCHRONOUS_REPLICATION, redepConfig.getAsynReplication())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_LOAD_BALANCING_ENABLED, redepConfig.getLenabled())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_KEEP_STATE, redepConfig.getKeepState())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_LIBRARIES, redepConfig.getLibraries())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_TYPE, redepConfig.getType())).addArgument(CommandArgumentFactory.buildDeploymentPropertyArgument(redepConfig.getProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_FILE, redepConfig.getFile())).setFriendlyErrorMessage("Unable to re-deploy the component.");
    }

    public static CommandBuilder buildSetCommand(Configuration configuration, Property property) {
        return CommandFactory.create(CommandName.SET, configuration).addArgument(CommandArgumentFactory.buildSetAttributeArgument(property)).setFriendlyErrorMessage("Unable to set the value [" + property.getValue() + "] for name [" + property.getName() + "]");
    }

    public static CommandBuilder buildSetJmsServiceAttributeCommand(Configuration configuration, Property property) {
        if (!property.getName().startsWith("server.jms-service.")) {
            property.setName("server.jms-service." + property.getName());
        }
        return CommandFactory.buildSetCommand(configuration, property);
    }

    public static CommandBuilder buildSetJmsHostAttributeCommand(Configuration configuration, JmsHost jmsHost, Property property) {
        if (!property.getName().startsWith("server.jms-service.jms-host." + jmsHost.getName() + ".")) {
            property.setName("server.jms-service.jms-host." + jmsHost.getName() + "." + property.getName());
        }
        return CommandFactory.buildSetCommand(configuration, property);
    }

    public static CommandBuilder buildSetLoggingAttributesCommand(Configuration configuration) {
        if (configuration.getDomain().getLoggingAttributes() != null && !configuration.getDomain().getLoggingAttributes().isEmpty()) {
            return CommandFactory.create(CommandName.SET_LOG_ATTRIBUTES, configuration).addArgument(CommandArgumentFactory.buildPropertyWithoutNameArgument(configuration.getDomain().getLoggingAttributes())).setFriendlyErrorMessage("Unable to set one or more logging attributes to the domain.");
        }
        return null;
    }

    public static CommandBuilder buildStartDomainCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.START_DOMAIN, configuration).addArgument(CommandArgumentFactory.buildDebugArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainDirectoryArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainNameArgument(configuration)).setFriendlyErrorMessage("Unable to start the domain.");
    }

    public static CommandBuilder buildStopDomainCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.STOP_DOMAIN, configuration).addArgument(CommandArgumentFactory.buildDomainDirectoryArgument(configuration)).addArgument(CommandArgumentFactory.buildDomainNameArgument(configuration)).setFriendlyErrorMessage("Unable to stop the domain.");
    }

    public static CommandBuilder buildUndeployCommand(Configuration configuration) {
        return CommandFactory.create(CommandName.UNDEPLOY, configuration).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_DROP_TABLES, configuration.getUndeployConfiguration().getDropTables())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.DEP_CASCADE, configuration.getUndeployConfiguration().getCascade())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.DEP_FILE, configuration.getUndeployConfiguration().getName())).setFriendlyErrorMessage("Unable to undeploy the component.");
    }

    public static CommandBuilder buildCreateConnectorConnectionPoolCommand(Configuration configuration, ConnectorConnectionPool connectorConnectionPool) {
        return CommandFactory.create(CommandName.CREATE_CONNECTOR_CONNECTION_POOL, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.CONNECTOR_CONNECTION_POOL_RANAME, connectorConnectionPool.getRaname())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.CONNECTOR_CONNECTION_POOL_CONNECTION_DEFINITION, connectorConnectionPool.getConnectionDefinition())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.CONNECTOR_CONNECTION_POOL_PING, connectorConnectionPool.getPing())).addArgument(CommandArgumentFactory.buildBooleanArgument(CommandArgumentName.CONNECTOR_CONNECTION_POOL_IS_CONNECT_VALIDATE_REQ, connectorConnectionPool.getIsConnectValidateReq())).addArgument(CommandArgumentFactory.buildPropertyArgument(connectorConnectionPool.getProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, connectorConnectionPool.getJndiName())).setFriendlyErrorMessage("Unable to create the connector connection pool.");
    }

    public static CommandBuilder buildCreateAdapterConfigCommand(Configuration configuration, ResourceAdapter resourceAdapter) {
        return CommandFactory.create(CommandName.CREATE_RESOURCE_ADAPTER_CONFIG, configuration).addArgument(CommandArgumentFactory.buildPropertyArgument(resourceAdapter.getProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.RESOURCE_ADAPTER_NAME, resourceAdapter.getDeployConfig().getName())).setFriendlyErrorMessage("Unable to configure the resource adapter.");
    }

    public static CommandBuilder buildCreateConnectorConnectionPoolCommand(Configuration configuration, ConnectorResource connectorResource) {
        return CommandFactory.create(CommandName.CREATE_CONNECTOR_RESOURCE, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.CONNECTOR_RESOURCE_CONNECTION_POOL_NAME, connectorResource.getPoolName())).addArgument(CommandArgumentFactory.buildPropertyArgument(connectorResource.getProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, connectorResource.getJndiName())).setFriendlyErrorMessage("Unable to create the connector resource.");
    }

    public static CommandBuilder buildCreateAdminObjectCommand(Configuration configuration, AdminObject adminObject) {
        return CommandFactory.create(CommandName.CREATE_ADMIN_OBJECT, configuration).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.CONNECTOR_CONNECTION_POOL_RANAME, adminObject.getRaname())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.RESOURCE_TYPE, adminObject.getRestype())).addArgument(CommandArgumentFactory.buildPropertyArgument(adminObject.getProperties())).addArgument(CommandArgumentFactory.buildStringArgument(CommandArgumentName.JNDI_NAME, adminObject.getJndiName())).setFriendlyErrorMessage("Unable to create the connector resource.");
    }

    private static CommandBuilder create(CommandName name, Configuration configuration) {
        return new CommandBuilder(name).setupAsadminArguments(configuration);
    }
}

