/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.command;

import io.probedock.maven.plugin.glassfish.command.CommandBuilder;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class CommandExecutor {
    private static final int PROCESS_LOOP_SLEEP_MILLIS = 100;
    private static final int EXIT_SUCCESS = 0;
    private InputStream processOut;
    private InputStream processErr;
    protected Configuration configuration;
    private final File binDir;
    private File asadmin;

    public CommandExecutor(Configuration configuration) {
        this.configuration = configuration;
        this.binDir = new File(configuration.getGlassfish().getGlassfishDirectory(), "bin");
        this.asadmin = new File(this.binDir, "asadmin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandBuilder commandBuilder) throws MojoExecutionException, MojoFailureException {
        File asadminBat;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (System.getProperty("os.name").contains("indows") && (asadminBat = new File(this.binDir, "asadmin.bat")).exists()) {
            this.asadmin = asadminBat;
        }
        Log log = this.configuration.getLog();
        processBuilder.command(commandBuilder.getCommandLine(this.asadmin.getAbsolutePath()));
        try {
            int exitValue;
            Process process = processBuilder.start();
            this.processOut = process.getInputStream();
            this.processErr = process.getErrorStream();
            BufferedReader outReader = new BufferedReader(new InputStreamReader(this.processOut));
            block8: while (true) {
                try {
                    exitValue = process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    Thread.sleep(100L);
                }
                finally {
                    while (true) {
                        if (!outReader.ready()) continue block8;
                        log.info((CharSequence)outReader.readLine());
                    }
                }
                break;
            }
            if (exitValue != 0) {
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.processErr));
                while (errorReader.ready()) {
                    log.error((CharSequence)errorReader.readLine());
                }
                String errorMessage = commandBuilder.getFriendlyErrorMessage();
                log.error((CharSequence)errorMessage);
                log.error((CharSequence)"For more detail on what might be causing the problem try running maven with the --debug option ");
                log.error((CharSequence)"or setting the maven-glassfish-plugin [echo] property to [true].");
                throw new MojoFailureException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(commandBuilder.getFriendlyErrorMessage() + " IOException: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(commandBuilder.getFriendlyErrorMessage() + " Process was interrupted: " + e.getMessage());
        }
    }
}

