/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.command;

import io.probedock.maven.plugin.glassfish.command.CommandName;
import io.probedock.maven.plugin.glassfish.command.argument.Argument;
import io.probedock.maven.plugin.glassfish.command.argument.AsadminArgumentName;
import io.probedock.maven.plugin.glassfish.command.argument.CommandArgumentName;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import java.util.ArrayList;
import java.util.List;

public class CommandBuilder {
    private final CommandName name;
    private final List<String> asadminArguments;
    private final List<String> commandArguments;
    private String friendlyErrorMessage;

    public CommandBuilder(CommandName name) {
        this.name = name;
        this.commandArguments = new ArrayList<String>();
        this.asadminArguments = new ArrayList<String>();
    }

    public CommandBuilder addArgument(Argument<CommandArgumentName> argument) {
        if (argument != null) {
            this.commandArguments.addAll(argument.buildArgument());
        }
        return this;
    }

    public CommandBuilder setFriendlyErrorMessage(String message) {
        this.friendlyErrorMessage = message;
        return this;
    }

    public String getFriendlyErrorMessage() {
        return this.friendlyErrorMessage;
    }

    public CommandBuilder setupAsadminArguments(Configuration configuration) {
        this.asadminArguments.addAll(AsadminArgumentName.INTERACTIVE.create().buildArgument());
        if (configuration.getGlassfish().isEcho()) {
            this.asadminArguments.addAll(AsadminArgumentName.ECHO.create().buildArgument());
        }
        this.asadminArguments.addAll(AsadminArgumentName.TERSE.create(configuration).buildArgument());
        this.asadminArguments.addAll(AsadminArgumentName.USER.create(configuration).buildArgument());
        this.asadminArguments.addAll(AsadminArgumentName.PASSWORDFILE.create(configuration).buildArgument());
        if (configuration.getDomain().getHost() != null) {
            this.asadminArguments.addAll(AsadminArgumentName.HOST.create(configuration).buildArgument());
        }
        if (configuration.getDomain().getAdminPort() > 0) {
            this.asadminArguments.addAll(AsadminArgumentName.PORT.create(configuration).buildArgument());
        }
        return this;
    }

    public List<String> getCommandLine(String asadminPath) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(asadminPath);
        if (!this.asadminArguments.isEmpty()) {
            cmdLine.addAll(this.asadminArguments);
        }
        cmdLine.add(this.name.getCmd());
        if (!this.commandArguments.isEmpty()) {
            cmdLine.addAll(this.commandArguments);
        }
        return cmdLine;
    }
}

