/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish;

import io.probedock.maven.plugin.glassfish.command.CommandExecutor;
import io.probedock.maven.plugin.glassfish.macro.AbstractMacro;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import io.probedock.maven.plugin.glassfish.model.Domain;
import io.probedock.maven.plugin.glassfish.model.Glassfish;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class GlassfishMojo
extends AbstractMojo {
    @Parameter(required=true)
    protected Domain domain;
    @Parameter(required=true)
    protected Glassfish glassfish;
    protected Configuration configuration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.postConfig();
        this.getMacro().execute(new CommandExecutor(this.configuration));
    }

    private void postConfig() throws MojoExecutionException {
        List<String> configErrors = this.getConfigErrors();
        if (!configErrors.isEmpty()) {
            for (String s : configErrors) {
                this.getLog().error((CharSequence)s);
            }
            throw new MojoExecutionException("Unable to execute the maven goal");
        }
        this.configuration = this.buildConfiguration();
        if (this.glassfish.getDomainDirectory() == null) {
            this.glassfish.setDomainDirectory(new File(this.glassfish.getGlassfishDirectory(), "domains"));
        }
        if (this.domain.getDirectory() == null) {
            this.domain.setDirectory(this.glassfish.getDomainDirectory());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Finalized configuration: " + this.configuration));
        }
    }

    private List<String> getConfigErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.glassfish.getPasswordFile() == null) {
            StringBuilder error = new StringBuilder().append("inside the definition for plugin: 'maven-lotaris-glassfish-plugin' specify the following:\n\n").append("<configuration>\n").append("  ...\n").append("  <adminPasswordFile>VALUE</adminPasswordFile>\n").append("  ...\n").append("</configuration>\n");
            errors.add(error.toString());
        }
        return errors;
    }

    protected Configuration buildConfiguration() {
        return new Configuration(this.getLog(), this.glassfish, this.domain);
    }

    protected abstract AbstractMacro getMacro();
}

