/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish;

import io.probedock.maven.plugin.glassfish.GlassfishMojo;
import io.probedock.maven.plugin.glassfish.macro.AbstractMacro;
import io.probedock.maven.plugin.glassfish.macro.CreateDomainMacro;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import io.probedock.maven.plugin.glassfish.model.ConnectionFactory;
import io.probedock.maven.plugin.glassfish.model.JdbcResource;
import io.probedock.maven.plugin.glassfish.model.Property;
import java.lang.reflect.Field;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="create-domain", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=true)
public class CreateDomainGlassfishMojo
extends GlassfishMojo {
    @Override
    protected AbstractMacro getMacro() {
        return new CreateDomainMacro(this.configuration);
    }

    @Override
    protected Configuration buildConfiguration() {
        Configuration config = new Configuration(this.getLog(), this.glassfish, this.domain);
        if (this.domain.getConnectionFactories() != null) {
            for (ConnectionFactory connectionFactory : this.domain.getConnectionFactories()) {
                for (Property property : this.glassfish.getJmsDefaults()) {
                    try {
                        this.setFieldValue(connectionFactory, property);
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.getLog().warn((CharSequence)("No field " + property.getName() + " presents on connection factory object."));
                    }
                    catch (IllegalAccessException iae) {
                        this.getLog().warn((CharSequence)("Unable to set " + property.getName() + " on connection factory object."));
                    }
                }
            }
        }
        if (this.domain.getJdbcResources() != null) {
            for (JdbcResource jdbcResource : this.domain.getJdbcResources()) {
                for (Property property : this.glassfish.getJdbcDefaults()) {
                    try {
                        this.setFieldValue(jdbcResource, property);
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.getLog().warn((CharSequence)("No field " + property.getName() + " presents on JDBC resource object."));
                    }
                    catch (IllegalAccessException iae) {
                        this.getLog().warn((CharSequence)("Unable to set " + property.getName() + " on JDBC resource object."));
                    }
                }
            }
        }
        return config;
    }

    private void setFieldValue(Object obj, Property property) throws NoSuchFieldException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(property.getName());
        field.setAccessible(true);
        if (field.get(obj) == null) {
            if (field.getType() == Integer.class) {
                field.set(obj, Integer.valueOf(property.getValue()));
            } else if (field.getType() == Boolean.class) {
                field.set(obj, Boolean.valueOf(property.getValue()));
            } else {
                field.set(obj, property.getValue());
            }
        }
        field.setAccessible(false);
    }
}

