/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.demo.junit;

public abstract class Operation {
    private Operation leftOperation;
    private Operation rightOperation;
    protected int leftOperand;
    protected int rightOperand;

    public Operation(int leftOperand, int rightOperand) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    public Operation(Operation leftOperation, Operation rightOperation) {
        this.leftOperation = leftOperation;
        this.rightOperation = rightOperation;
    }

    public Operation(int leftOperand, Operation rightOperation) {
        this.leftOperand = leftOperand;
        this.rightOperation = rightOperation;
    }

    public Operation(Operation leftOperation, int rightOperand) {
        this.leftOperation = leftOperation;
        this.rightOperand = rightOperand;
    }

    public int process() {
        if (this.leftOperation != null) {
            this.leftOperand = this.leftOperation.process();
        }
        if (this.rightOperation != null) {
            this.rightOperand = this.rightOperation.process();
        }
        return this.calculate();
    }

    public Operation getLeftOperation() {
        return this.leftOperation;
    }

    public Operation getRightOperation() {
        return this.rightOperation;
    }

    public int getLeftOperand() {
        return this.leftOperand;
    }

    public int getRightOperand() {
        return this.rightOperand;
    }

    public String toString() {
        String left = this.leftOperation != null ? this.leftOperation.toString() : "" + this.leftOperand;
        String right = this.rightOperation != null ? this.rightOperation.toString() : "" + this.rightOperand;
        return "( " + left + " " + this.getSymbol() + " " + right + " )";
    }

    protected abstract int calculate();

    protected abstract String getSymbol();
}

