/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.junit;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.model.v1.ModelFactory;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.utils.Inflector;
import io.probedock.client.common.utils.TestResultDataUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public abstract class AbstractProbeListener
extends RunListener {
    private static final Logger LOGGER = Logger.getLogger(AbstractProbeListener.class.getCanonicalName());
    protected static final Configuration configuration = Configuration.getInstance();
    protected static final String DEFAULT_CATEGORY = "JUnit";
    protected Long runStartedDate;
    protected Map<String, Long> testStartDates = new HashMap<String, Long>();
    private boolean fullStackTraces = true;
    protected String category;

    public AbstractProbeListener() {
    }

    public AbstractProbeListener(String category) {
        this();
        this.category = category;
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
    }

    public void setFullStackTraces(Boolean fullStackTraces) {
        this.fullStackTraces = fullStackTraces;
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        this.runStartedDate = System.currentTimeMillis();
    }

    protected ProbeTest getMethodAnnotation(Description description) throws NoSuchMethodException {
        String methodName = description.getMethodName();
        if (methodName.contains("[")) {
            methodName = methodName.replaceAll("\\[.*\\]", "");
        }
        return description.getTestClass().getMethod(methodName, new Class[0]).getAnnotation(ProbeTest.class);
    }

    protected ProbeTestClass getClassAnnotation(Description description) {
        return description.getTestClass().getAnnotation(ProbeTestClass.class);
    }

    protected TestResult createTestResult(String fingerprint, Description description, ProbeTest mAnnotation, ProbeTestClass cAnnotation, boolean passed, String message) {
        TestResult result = ModelFactory.createTestResult((String)TestResultDataUtils.getKey((ProbeTest)mAnnotation), (String)fingerprint, (String)Inflector.forgeName((Class)description.getTestClass(), (String)description.getMethodName(), (ProbeTest)mAnnotation), (String)TestResultDataUtils.getCategory((Configuration)configuration, (ProbeTestClass)cAnnotation, (ProbeTest)mAnnotation, (String)this.getCategory()), (long)(System.currentTimeMillis() - this.testStartDates.get(fingerprint)), (String)message, (boolean)passed, (Boolean)TestResultDataUtils.isActive((ProbeTest)mAnnotation), (Set)TestResultDataUtils.getContributors((Configuration)configuration, (ProbeTestClass)cAnnotation, (ProbeTest)mAnnotation), (Set)TestResultDataUtils.getTags((Configuration)configuration, (ProbeTestClass)cAnnotation, (ProbeTest)mAnnotation), (Set)TestResultDataUtils.getTickets((Configuration)configuration, (ProbeTestClass)cAnnotation, (ProbeTest)mAnnotation), null);
        ModelFactory.enrichTestResult((TestResult)result, (String)description.getTestClass().getPackage().getName(), (String)description.getTestClass().getName(), (String)description.getMethodName());
        return result;
    }

    protected String createAndlogStackTrace(Failure failure) {
        StringBuilder sb = new StringBuilder();
        if (failure.getMessage() != null && !failure.getMessage().isEmpty()) {
            sb.append("Failure message: ").append(failure.getMessage());
        }
        if (failure.getException() != null) {
            sb.append("\n\n");
            sb.append(failure.getException().getClass().getCanonicalName()).append(": ").append(failure.getMessage()).append("\n");
            for (StackTraceElement ste : failure.getException().getStackTrace()) {
                sb.append("\tat ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
                if (this.fullStackTraces || !ste.getClassName().equals(failure.getDescription().getClassName())) continue;
                sb.append("\t...\n");
                break;
            }
            if (this.fullStackTraces && failure.getException().getCause() != null) {
                sb.append("Cause: ").append(failure.getException().getCause().getMessage()).append("\n");
                for (StackTraceElement ste : failure.getException().getCause().getStackTrace()) {
                    sb.append("\tat ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
                }
            }
            LOGGER.info("\n" + failure.getTestHeader() + "\n" + sb.toString());
        }
        return sb.toString();
    }

    protected final String getFingerprint(Description description) {
        return TestResultDataUtils.getFingerprint((Class)description.getTestClass(), (String)description.getMethodName());
    }

    protected final String getCategory() {
        return this.category != null && !this.category.isEmpty() ? this.category : DEFAULT_CATEGORY;
    }
}

