/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.junit;

import io.probedock.client.ProbeRuntimeException;
import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.common.model.v1.Context;
import io.probedock.client.common.model.v1.ModelFactory;
import io.probedock.client.common.model.v1.Probe;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.model.v1.TestRun;
import io.probedock.client.core.connector.Connector;
import io.probedock.client.core.storage.FileStore;
import io.probedock.client.junit.AbstractProbeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class ProbeListener
extends AbstractProbeListener {
    private static final Logger LOGGER = Logger.getLogger(ProbeListener.class.getCanonicalName());
    private static final String PROBE_DOCK_NAME = "Junit";
    private static final String PROBE_DOCK_VERSION = ResourceBundle.getBundle("version").getString("version");
    protected Context context;
    protected TestRun testRun;
    private List<TestResult> results = new ArrayList<TestResult>();
    private Set<String> testFailures = new HashSet<String>();

    public ProbeListener() {
    }

    public ProbeListener(String category) {
        super(category);
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        if (configuration.isDisabled()) {
            return;
        }
        this.context = ModelFactory.createContext();
        Probe probe = ModelFactory.createProbe((String)PROBE_DOCK_NAME, (String)PROBE_DOCK_VERSION);
        this.testRun = ModelFactory.createTestRun((Configuration)Configuration.getInstance(), (Context)this.context, (Probe)probe, (String)configuration.getProjectApiId(), (String)configuration.getProjectVersion(), (String)configuration.getPipeline(), (String)configuration.getStage(), null, null);
    }

    public void testRunFinished(Result result) throws Exception {
        if (configuration.isDisabled()) {
            return;
        }
        if (!this.results.isEmpty()) {
            ModelFactory.enrichContext((Context)this.context);
            long runEndedDate = System.currentTimeMillis();
            this.testRun.setDuration(runEndedDate - this.runStartedDate);
            this.testRun.addTestResults(this.results);
            try {
                this.publishTestRun();
            }
            catch (ProbeRuntimeException pre) {
                LOGGER.log(Level.WARNING, "Could not publish or save test run", pre);
            }
        }
    }

    private void publishTestRun() throws IOException {
        if (configuration.isPublish() || configuration.isSave()) {
            if (configuration.isSave()) {
                new FileStore(configuration).save((ProbeTestRun)this.testRun);
            }
            if (configuration.isPublish()) {
                new Connector(configuration).send((ProbeTestRun)this.testRun);
            }
        }
    }

    @Override
    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        if (configuration.isDisabled()) {
            return;
        }
        this.testStartDates.put(this.getFingerprint(description), System.currentTimeMillis());
    }

    @Override
    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (configuration.isDisabled()) {
            return;
        }
        ProbeTest mAnnotation = this.getMethodAnnotation(description);
        ProbeTestClass cAnnotation = this.getClassAnnotation(description);
        String fingerprint = this.getFingerprint(description);
        if (!this.testFailures.contains(fingerprint)) {
            TestResult testResult = this.createTestResult(fingerprint, description, mAnnotation, cAnnotation, true, null);
            this.results.add(testResult);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        if (configuration.isDisabled()) {
            return;
        }
        ProbeTest mAnnotation = this.getMethodAnnotation(failure.getDescription());
        ProbeTestClass cAnnotation = this.getClassAnnotation(failure.getDescription());
        String fingerprint = this.getFingerprint(failure.getDescription());
        this.testFailures.add(fingerprint);
        TestResult testResult = this.createTestResult(fingerprint, failure.getDescription(), mAnnotation, cAnnotation, false, this.createAndlogStackTrace(failure));
        this.results.add(testResult);
    }
}

