/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.junit;

import io.probedock.client.core.filters.FilterDefinition;
import io.probedock.client.core.filters.FilterDefinitionImpl;
import io.probedock.client.core.filters.FilterUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class ProbeFilter
extends Filter {
    private List<FilterDefinition> filters;

    public ProbeFilter() {
        this.filters = new ArrayList<FilterDefinition>();
    }

    public ProbeFilter(List<FilterDefinition> filters) {
        this.filters = filters;
    }

    public void addFilter(String filter) {
        boolean found = false;
        if (this.filters != null) {
            for (FilterDefinition filterDefinition : this.filters) {
                if (!filterDefinition.getText().equalsIgnoreCase(filter)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.filters.add((FilterDefinition)new FilterDefinitionImpl("*", filter));
            }
        }
    }

    public boolean shouldRun(Description description) {
        if (!description.isTest()) {
            return true;
        }
        if (description.isSuite()) {
            return false;
        }
        return FilterUtils.isRunnable((Class)description.getTestClass(), (String)description.getMethodName(), this.filters);
    }

    public String describe() {
        return "";
    }
}

