/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.junit;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.model.v1.ModelFactory;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.utils.Inflector;
import io.probedock.client.common.utils.MetaDataBuilder;
import io.probedock.client.junit.StandardTestMetaDataExtractor;
import io.probedock.client.junit.TestMetaDataExtratctor;
import io.probedock.client.utils.CollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProbeListener
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProbeListener.class);
    protected static final Configuration configuration = Configuration.getInstance();
    private static final String DEFAULT_CATEGORY = "JUnit";
    private static final String DEFAULT_TAG = "unit";
    protected Long runStartedDate;
    protected Map<String, Long> testStartDates = new HashMap<String, Long>();
    private boolean fullStackTraces = true;
    private String category;
    private final List<TestMetaDataExtratctor> extractors = new ArrayList<TestMetaDataExtratctor>();

    public AbstractProbeListener() {
        this.extractors.add(new StandardTestMetaDataExtractor());
    }

    public AbstractProbeListener(String category) {
        this();
        this.category = category;
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        for (TestMetaDataExtratctor extractor : this.extractors) {
            extractor.before(description);
        }
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        for (TestMetaDataExtratctor extractor : this.extractors) {
            extractor.after(description);
        }
    }

    public void setFullStackTraces(Boolean fullStackTraces) {
        this.fullStackTraces = fullStackTraces;
    }

    public void addExctractor(TestMetaDataExtratctor extractor) {
        this.extractors.add(extractor);
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        this.runStartedDate = System.currentTimeMillis();
    }

    protected ProbeTest getMethodAnnotation(Description description) throws NoSuchMethodException {
        return description.getTestClass().getMethod(description.getMethodName(), new Class[0]).getAnnotation(ProbeTest.class);
    }

    protected ProbeTestClass getClassAnnotation(Description description) {
        return description.getTestClass().getAnnotation(ProbeTestClass.class);
    }

    protected TestResult createTestResult(Description description, ProbeTest mAnnotation, ProbeTestClass cAnnotation, boolean passed, String message) {
        MetaDataBuilder data = new MetaDataBuilder();
        for (TestMetaDataExtratctor extractor : this.extractors) {
            data.add(extractor.extract(description));
        }
        return ModelFactory.createTestResult((String)this.getKey(mAnnotation), (String)this.getName(description, mAnnotation), (String)this.getCategory(cAnnotation, mAnnotation), (long)(System.currentTimeMillis() - this.testStartDates.get(this.getTechnicalName(description))), (String)message, (boolean)passed, (Boolean)this.isActive(mAnnotation), this.getTags(mAnnotation, cAnnotation), this.getTickets(mAnnotation, cAnnotation), (Map)data.toMetaData());
    }

    private String getKey(ProbeTest annotation) {
        return annotation != null && annotation.key() != null && !annotation.key().isEmpty() ? annotation.key() : null;
    }

    private Boolean isActive(ProbeTest annotation) {
        return annotation != null ? Boolean.valueOf(annotation.active()) : null;
    }

    private String getName(Description description, ProbeTest mAnnotation) {
        if (mAnnotation == null || mAnnotation.name() == null || mAnnotation.name().isEmpty()) {
            return Inflector.getHumanName((String)(description.getTestClass().getSimpleName() + " " + description.getMethodName()));
        }
        return mAnnotation.name();
    }

    protected String getCategory(ProbeTestClass classAnnotation, ProbeTest methodAnnotation) {
        if (methodAnnotation != null && methodAnnotation.category() != null && !methodAnnotation.category().isEmpty()) {
            return methodAnnotation.category();
        }
        if (classAnnotation != null && classAnnotation.category() != null && !classAnnotation.category().isEmpty()) {
            return classAnnotation.category();
        }
        if (configuration.getCategory() != null && !configuration.getCategory().isEmpty()) {
            return configuration.getCategory();
        }
        if (this.category != null) {
            return this.category;
        }
        return DEFAULT_CATEGORY;
    }

    private Set<String> getTags(ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        Set tags = CollectionHelper.getTags((Set)configuration.getTags(), (ProbeTest)methodAnnotation, (ProbeTestClass)classAnnotation);
        if (!tags.contains(DEFAULT_TAG)) {
            tags.add(DEFAULT_TAG);
        }
        return tags;
    }

    private Set<String> getTickets(ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        return CollectionHelper.getTickets((Set)configuration.getTickets(), (ProbeTest)methodAnnotation, (ProbeTestClass)classAnnotation);
    }

    protected String createAndlogStackTrace(Failure failure) {
        StringBuilder sb = new StringBuilder();
        if (failure.getMessage() != null && !failure.getMessage().isEmpty()) {
            sb.append("Failure message: ").append(failure.getMessage());
        }
        if (failure.getException() != null) {
            sb.append("\n\n");
            sb.append(failure.getException().getClass().getCanonicalName()).append(": ").append(failure.getMessage()).append("\n");
            for (StackTraceElement ste : failure.getException().getStackTrace()) {
                sb.append("\tat ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
                if (this.fullStackTraces || !ste.getClassName().equals(failure.getDescription().getClassName())) continue;
                sb.append("\t...\n");
                break;
            }
            if (this.fullStackTraces && failure.getException().getCause() != null) {
                sb.append("Cause: ").append(failure.getException().getCause().getMessage()).append("\n");
                for (StackTraceElement ste : failure.getException().getCause().getStackTrace()) {
                    sb.append("\tat ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
                }
            }
            LOGGER.info("\n{}\n{}", (Object)failure.getTestHeader(), (Object)sb.toString());
        }
        return sb.toString();
    }

    protected String getTechnicalName(Description description) {
        return description.getClassName() + "." + description.getMethodName();
    }
}

