/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.junit;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.config.ProbeRuntimeException;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.common.model.v1.ModelFactory;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.model.v1.TestRun;
import io.probedock.client.core.connector.Connector;
import io.probedock.client.core.storage.FileStore;
import io.probedock.client.junit.AbstractProbeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeListener
extends AbstractProbeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeListener.class);
    private List<TestResult> results = new ArrayList<TestResult>();
    private Set<String> testFailures = new HashSet<String>();

    public ProbeListener() {
    }

    public ProbeListener(String category) {
        super(category);
    }

    public void testRunFinished(Result result) throws Exception {
        if (configuration.isDisabled()) {
            return;
        }
        if (!this.results.isEmpty()) {
            try {
                this.publishTestRun();
            }
            catch (ProbeRuntimeException pre) {
                LOGGER.warn("Could not publish or save test run", (Throwable)pre);
            }
        }
    }

    private void publishTestRun() throws IOException {
        if (configuration.isPublish() || configuration.isSave()) {
            long runEndedDate = System.currentTimeMillis();
            String uid = configuration.getCurrentUid();
            TestRun testRun = ModelFactory.createTestRun((String)configuration.getProjectApiId(), (String)configuration.getProjectVersion(), (long)(runEndedDate - this.runStartedDate), this.results, uid != null ? Arrays.asList(ModelFactory.createTestReport((String)uid)) : null);
            if (configuration.isSave()) {
                new FileStore(configuration).save((ProbeTestRun)testRun);
            }
            if (configuration.isPublish()) {
                new Connector(configuration).send((ProbeTestRun)testRun);
            }
        }
    }

    @Override
    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        if (configuration.isDisabled()) {
            return;
        }
        this.testStartDates.put(this.getTechnicalName(description), System.currentTimeMillis());
    }

    @Override
    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (configuration.isDisabled()) {
            return;
        }
        ProbeTest mAnnotation = this.getMethodAnnotation(description);
        ProbeTestClass cAnnotation = this.getClassAnnotation(description);
        if (!this.testFailures.contains(this.getTechnicalName(description))) {
            TestResult testResult = this.createTestResult(description, mAnnotation, cAnnotation, true, null);
            this.results.add(testResult);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        if (configuration.isDisabled()) {
            return;
        }
        ProbeTest mAnnotation = this.getMethodAnnotation(failure.getDescription());
        ProbeTestClass cAnnotation = this.getClassAnnotation(failure.getDescription());
        this.testFailures.add(this.getTechnicalName(failure.getDescription()));
        TestResult testResult = this.createTestResult(failure.getDescription(), mAnnotation, cAnnotation, false, this.createAndlogStackTrace(failure));
        this.results.add(testResult);
    }
}

