/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.junit;

import io.probedock.client.core.filters.FilterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class ProbeFilter
extends Filter {
    private List<String> filters;

    public ProbeFilter() {
        this.filters = new ArrayList<String>();
    }

    public ProbeFilter(String[] filters) {
        this.filters = Arrays.asList(filters);
    }

    public void addFilter(String filter) {
        if (this.filters != null && filter != null && !filter.isEmpty() && !this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    public boolean shouldRun(Description description) {
        if (!description.isTest()) {
            return true;
        }
        return FilterUtils.isRunnable((Class)description.getTestClass(), (String)description.getMethodName(), (String[])this.filters.toArray(new String[this.filters.size()]));
    }

    public String describe() {
        return "";
    }
}

