/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.utils;

import java.util.Map;
import java.util.regex.Pattern;

public class EnvironmentUtils {
    public static final Pattern BOOLEAN_PATTERN = Pattern.compile("\\A(1|y|yes|t|true)\\Z", 2);
    public static final String ENV_PREFIX = "PROBEDOCK_";
    private static Map<String, String> envVars;

    public static void setEnvVars(Map<String, String> envVars) {
        EnvironmentUtils.envVars = envVars;
    }

    public static Boolean getEnvironmentBoolean(String name, Boolean defaultValue) {
        if (envVars == null) {
            throw new IllegalStateException("The environment vars must be provided before calling getEnvironmentBoolean.");
        }
        String value = EnvironmentUtils.getEnvironmentString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return BOOLEAN_PATTERN.matcher(value).matches();
    }

    public static Integer getEnvironmentInteger(String name, Integer defaultValue) {
        if (envVars == null) {
            throw new IllegalStateException("The environment vars must be provided before calling getEnvironmentInteger.");
        }
        String value = EnvironmentUtils.getEnvironmentString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static String getEnvironmentString(String name, String defaultValue) {
        if (envVars == null) {
            throw new IllegalStateException("The environment vars must be provided before calling getEnvironmentString.");
        }
        return envVars.get(ENV_PREFIX + name) != null ? envVars.get(ENV_PREFIX + name) : defaultValue;
    }
}

