/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.model.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.common.model.v1.Context;
import io.probedock.client.common.model.v1.Probe;
import io.probedock.client.common.model.v1.TestReport;
import io.probedock.client.common.model.v1.TestResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestRun
implements ProbeTestRun {
    @JsonIgnore
    private static final String API_VERSION = "v1";
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="pipeline")
    private String pipeline;
    @JsonProperty(value="stage")
    private String stage;
    @JsonUnwrapped
    private Context context;
    @JsonProperty(value="probe")
    private Probe probe;
    @JsonProperty(value="results")
    private List<TestResult> testResults = new ArrayList<TestResult>();
    @JsonProperty(value="data")
    private Map<String, String> data;
    @JsonProperty(value="reports")
    private List<TestReport> testReports = new ArrayList<TestReport>();

    @Override
    @JsonIgnore
    public String getApiVersion() {
        return API_VERSION;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public String getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public Probe getProbe() {
        return this.probe;
    }

    public void setProbe(Probe probe) {
        this.probe = probe;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    public void addData(Map<String, String> data) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.putAll(data);
    }

    public void addData(String key, String value) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, value);
    }

    public void addDataNullAvoided(String key, String value) {
        if (value != null) {
            this.addData(key, value);
        }
    }

    public void addDataNullAvoided(String key, Object value) {
        if (value != null) {
            this.addData(key, value.toString());
        }
    }

    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    public void addTestResults(List<TestResult> results) {
        this.testResults.addAll(results);
    }

    public List<TestReport> getTestReports() {
        return this.testReports;
    }

    public String toString() {
        StringBuilder sbTestResults = new StringBuilder();
        for (TestResult testResult : this.testResults) {
            sbTestResults.append(testResult).append(", ");
        }
        StringBuilder sbTestReports = new StringBuilder();
        for (TestReport testReport : this.testReports) {
            sbTestResults.append(testReport).append(", ");
        }
        StringBuilder sbData = new StringBuilder();
        if (this.data != null) {
            for (Map.Entry<String, String> e : this.data.entrySet()) {
                sbData.append("Data[Key: [").append(e.getKey()).append("], Value: [").append(e.getValue()).append("], ");
            }
        }
        return "TestRun: [ProjectId: " + this.projectId + ", " + "Version: " + this.version + ", " + "Duration: " + this.duration + ", " + "Pipeline: " + this.pipeline + ", " + "Stage: " + this.stage + ", " + "Context: " + this.context + ", " + "Probe: " + this.probe + ", " + "Data: [" + sbData.toString().replaceAll(", $", "") + "]" + "Results: [" + sbTestResults.toString().replaceAll(", $", "") + "]" + "Reports: [" + sbTestReports.toString().replaceAll(", $", "") + "]" + "]";
    }
}

