/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.common.config.ServerConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServerListConfiguration {
    private Map<String, ServerConfiguration> servers = new HashMap<String, ServerConfiguration>();

    public void configureServer(String name, Map<String, Object> data) {
        ServerConfiguration server = this.servers.get(name);
        if (server == null) {
            server = new ServerConfiguration(name);
            this.servers.put(name, server);
        }
        server.configureWith(data);
    }

    public ServerConfiguration get(String name) {
        return this.servers.get(name);
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public Set<String> getServerNames() {
        return Collections.unmodifiableSet(this.servers.keySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Server list:");
        for (ServerConfiguration server : this.servers.values()) {
            builder.append("\n- ").append(server);
        }
        return builder.toString();
    }
}

