/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.common.config.ProbeConfigurationException;
import io.probedock.client.common.config.ServerConfiguration;
import io.probedock.client.common.config.ServerListConfiguration;
import io.probedock.client.common.config.YamlConfigurationFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;

public class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getCanonicalName());
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("\\A(1|y|yes|t|true)\\Z", 2);
    private static final String DEFAULT_HOMEDIR = System.getProperty("user.home") + "/.probedock";
    private static final String BASE_CONFIG_PATH = ".probedock/config.yml";
    private static final String CLASSPATH_CONFIG = "probedock.yml";
    private static final String UID_FILE_NAME = "uid";
    protected static final String P_ROOT_NODE_NAME = "probedock";
    private static final String ENV_PREFIX = "PROBEDOCK_";
    private static final String ENV_TEST_REPORT_UID = "TEST_REPORT_UID";
    private static final String P_WORKSPACE = "probedock.workspace";
    private static final String P_SERVER = "probedock.server";
    private static final String P_CONTRIBUTORS = "probedock.contributors";
    private static final String P_TAGS = "probedock.tags";
    private static final String P_TICKETS = "probedock.tickets";
    private static final String P_CATEGORY = "probedock.category";
    private static final String P_PIPELINE = "probedock.pipeline";
    private static final String P_STAGE = "probedock.stage";
    private static final String P_PUBLISH = "probedock.publish";
    private static final String P_GENERATORSEED = "probedock.seed";
    private static final String P_PAYLOAD_PRINT = "probedock.payload.print";
    private static final String P_PAYLOAD_SAVE = "probedock.payload.save";
    private static final String P_SERIALIZER_CLASS = "probedock.java.serializerClass";
    private static final String P_PROJECT_API_ID = "probedock.project.apiId";
    private static final String P_PROJECT_VERSION = "probedock.project.version";
    private static final String P_PROJECT_CATEGORY = "probedock.project.category";
    private static final String P_PROJECT_CONTRIBUTORS = "probedock.project.contributors";
    private static final String P_PROJECT_TAGS = "probedock.project.tags";
    private static final String P_PROJECT_TICKETS = "probedock.project.tickets";
    private static final String P_PROJECT_GENERATORSEED = "probedock.project.seed";
    private static Configuration instance;
    protected CompositeConfiguration config = new CompositeConfiguration();
    private ServerListConfiguration serverList = new ServerListConfiguration();
    private Set<String> contributors;
    private Set<String> tags;
    private Set<String> tickets;
    private boolean disabled = false;

    protected Configuration() {
        try {
            this.config.addConfiguration((org.apache.commons.configuration.Configuration)new YamlConfigurationFile(CLASSPATH_CONFIG, P_ROOT_NODE_NAME, this.serverList));
        }
        catch (ConfigurationException ce) {
            if (LOGGER.getLevel() == Level.FINEST) {
                LOGGER.log(Level.FINEST, "Unable to load the project configuration.", ce);
            }
            LOGGER.warning("Unable to load the project configuration due to: " + ce.getMessage());
        }
        try {
            this.config.addConfiguration((org.apache.commons.configuration.Configuration)new YamlConfigurationFile(BASE_CONFIG_PATH, P_ROOT_NODE_NAME, this.serverList));
        }
        catch (ConfigurationException ce) {
            if (LOGGER.getLevel() == Level.FINEST) {
                LOGGER.log(Level.FINEST, "Unable to load the Probe Dock configuration.", ce);
            }
            LOGGER.warning("Unable to load the Probe Dock configuration due to: " + ce.getMessage());
        }
        if (!this.serverList.isEmpty()) {
            LOGGER.fine(this.getServerListDescription());
        }
        ServerConfiguration server = this.getInternalServerConfiguration();
        if (this.config.getNumberOfConfigurations() == 0) {
            this.disabled = true;
        } else if (this.serverList.isEmpty()) {
            this.disabled = true;
            LOGGER.warning("No server is defined in the Probe Dock configuration files; define servers under the \"servers\" property.");
        } else if (server == null) {
            this.disabled = true;
            LOGGER.warning("No known server is selected in the Probe Dock configuration files; set the \"server\" property to the name of one of the configured servers.");
        } else if (!server.isValid()) {
            this.disabled = true;
            LOGGER.warning("The selected server (" + server.getName() + ") in the Probe Dock configuration file is invalid");
        }
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    private String getMandatory(String name) {
        if (!this.config.containsKey(name)) {
            throw new ProbeConfigurationException(name + " parameter is missing.");
        }
        return this.config.getString(name);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public final String getWorkspace() {
        return this.getEnvironmentString("WORKSPACE", this.config.getString(P_WORKSPACE, DEFAULT_HOMEDIR)).replace("~", System.getProperty("user.home"));
    }

    public String getSerializer() {
        return this.config.getString(P_SERIALIZER_CLASS);
    }

    public ServerConfiguration getServerConfiguration() {
        return this.getInternalServerConfiguration();
    }

    private ServerConfiguration getInternalServerConfiguration() {
        return this.serverList.get(this.getEnvironmentString("SERVER", this.config.getString(P_SERVER)));
    }

    private String getServerListDescription() {
        StringBuilder builder = new StringBuilder("Probe Dock server list: ");
        for (String serverName : this.serverList.getServerNames()) {
            if (builder.charAt(builder.length() - 1) != ' ') {
                builder.append(", ");
            }
            builder.append(serverName);
            if (!this.serverList.get(serverName).isValid()) {
                builder.append(" (INVALID)");
                continue;
            }
            if (!serverName.equals(this.config.getString(P_SERVER))) continue;
            builder.append(" (selected)");
        }
        return builder.toString();
    }

    public String getProjectApiId() {
        ServerConfiguration server = this.getInternalServerConfiguration();
        if (server != null && server.getProjectApiId() != null) {
            return server.getProjectApiId();
        }
        String globalProjectApiId = this.config.getString(P_PROJECT_API_ID);
        if (globalProjectApiId == null) {
            throw new ProbeConfigurationException("Probe Dock project API identifier is missing; set the project.apiId property or the projectApiId property of the selected server.");
        }
        return globalProjectApiId;
    }

    public String getProjectVersion() {
        return this.getMandatory(P_PROJECT_VERSION);
    }

    public String getPipeline() {
        return this.config.getString(P_PIPELINE);
    }

    public String getStage() {
        return this.config.getString(P_STAGE);
    }

    public Long getGeneratorSeed() {
        if (this.config.containsKey(P_PROJECT_GENERATORSEED)) {
            return this.config.getLong(P_PROJECT_GENERATORSEED, null);
        }
        return this.config.getLong(P_GENERATORSEED, null);
    }

    public boolean isPayloadPrint() {
        return this.getEnvironmentBoolean("PRINT_PAYLOAD", this.config.getBoolean(P_PAYLOAD_PRINT, Boolean.FALSE));
    }

    public Set<String> getTags() {
        if (this.tags == null) {
            List projectTags;
            this.tags = new HashSet<String>();
            List globalTags = (List)this.config.getProperty(P_TAGS);
            if (globalTags != null && !globalTags.isEmpty()) {
                this.tags.addAll(globalTags);
            }
            if ((projectTags = (List)this.config.getProperty(P_PROJECT_TAGS)) != null && !projectTags.isEmpty()) {
                this.tags.addAll(projectTags);
            }
        }
        return this.tags;
    }

    public Set<String> getTickets() {
        if (this.tickets == null) {
            List projectTickets;
            this.tickets = new HashSet<String>();
            List globalTickets = (List)this.config.getProperty(P_TICKETS);
            if (globalTickets != null && !globalTickets.isEmpty()) {
                this.tickets.addAll(globalTickets);
            }
            if ((projectTickets = (List)this.config.getProperty(P_PROJECT_TICKETS)) != null && !projectTickets.isEmpty()) {
                this.tickets.addAll(projectTickets);
            }
        }
        return this.tickets;
    }

    public Set<String> getContributors() {
        if (this.contributors == null) {
            List projectContributors;
            this.contributors = new HashSet<String>();
            List globalContributors = (List)this.config.getProperty(P_CONTRIBUTORS);
            if (globalContributors != null && !globalContributors.isEmpty()) {
                this.contributors.addAll(globalContributors);
            }
            if ((projectContributors = (List)this.config.getProperty(P_PROJECT_CONTRIBUTORS)) != null && !projectContributors.isEmpty()) {
                this.contributors.addAll(projectContributors);
            }
        }
        return this.contributors;
    }

    public String getCategory() {
        if (this.config.containsKey(P_PROJECT_CATEGORY)) {
            return this.config.getString(P_PROJECT_CATEGORY);
        }
        return this.config.getString(P_CATEGORY);
    }

    public boolean isSave() {
        return this.getEnvironmentBoolean("SAVE_PAYLOAD", this.config.getBoolean(P_PAYLOAD_SAVE, Boolean.FALSE));
    }

    public boolean isPublish() {
        return this.getEnvironmentBoolean("PUBLISH", this.config.getBoolean(P_PUBLISH, Boolean.TRUE));
    }

    private boolean getEnvironmentBoolean(String name, boolean defaultValue) {
        String value = this.getEnvironmentString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return BOOLEAN_PATTERN.matcher(value).matches();
    }

    private String getEnvironmentString(String name, String defaultValue) {
        return System.getenv(ENV_PREFIX + name) != null ? System.getenv(ENV_PREFIX + name) : defaultValue;
    }

    public String getCurrentUid() {
        return this.getEnvironmentString(ENV_TEST_REPORT_UID, this.readUid(new File(UID_FILE_NAME)));
    }

    private String readUid(File uidFile) {
        String uid = null;
        try (BufferedReader br = new BufferedReader(new FileReader(uidFile));){
            String line;
            while ((line = br.readLine()) != null) {
                uid = line;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return uid;
    }
}

