/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.utils;

import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

public class FingerprintGenerator {
    private static final Logger LOGGER = Logger.getLogger(FingerprintGenerator.class.getCanonicalName());

    public static String fingerprint(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return FingerprintGenerator.byteArrayToHexString(md.digest(str.getBytes()));
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.warning("Unable to calculate the fingerprint for string [" + str + "].");
            return null;
        }
    }

    public static String fingerprint(Class cl, Method m) {
        return FingerprintGenerator.fingerprint(cl, m.getName());
    }

    public static String fingerprint(Class cl, String methodName) {
        return FingerprintGenerator.fingerprint(cl.getCanonicalName() + "." + methodName);
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder result = new StringBuilder();
        for (byte b : byteArray) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

