/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.utils;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionHelper.class);
    private static final Pattern tagPattern = Pattern.compile("[a-zA-z0-9-_]*");

    public static Set<String> getTags(Set<String> baseTags, ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        Set<Object> tags = baseTags == null ? new HashSet() : CollectionHelper.populateTags(baseTags, new HashSet<String>());
        if (classAnnotation != null && classAnnotation.tags() != null) {
            tags = CollectionHelper.populateTags(new HashSet<String>(Arrays.asList(classAnnotation.tags())), tags);
        }
        if (methodAnnotation != null && methodAnnotation.tags() != null) {
            tags = CollectionHelper.populateTags(new HashSet<String>(Arrays.asList(methodAnnotation.tags())), tags);
        }
        return tags;
    }

    private static Set<String> populateTags(Set<String> source, Set<String> destination) {
        for (String tag : source) {
            if (!tagPattern.matcher(tag).matches()) {
                LOGGER.warn("The tag {} does not respect the following pattern {} and is ignored", (Object)tag, (Object)tagPattern.pattern());
                continue;
            }
            if (destination.contains(tag)) {
                LOGGER.info("The tag {} is already present in the collection and is ingored", (Object)tag);
                continue;
            }
            destination.add(tag);
        }
        return destination;
    }

    public static Set<String> getTickets(Set<String> basedTickets, ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        Set<Object> tickets = basedTickets == null ? new HashSet() : CollectionHelper.populateTickets(basedTickets, new HashSet<String>());
        if (classAnnotation != null && classAnnotation.tickets() != null) {
            tickets = CollectionHelper.populateTickets(new HashSet<String>(Arrays.asList(classAnnotation.tickets())), tickets);
        }
        if (methodAnnotation != null && methodAnnotation.tickets() != null) {
            tickets = CollectionHelper.populateTickets(new HashSet<String>(Arrays.asList(methodAnnotation.tickets())), tickets);
        }
        return tickets;
    }

    private static Set<String> populateTickets(Set<String> source, Set<String> destination) {
        for (String ticket : source) {
            if (destination.contains(ticket)) {
                LOGGER.info("The ticket {} is already present in the collection and is ingored", (Object)ticket);
                continue;
            }
            destination.add(ticket);
        }
        return destination;
    }
}

