/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.filters;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.core.filters.FilterTargetData;
import java.lang.reflect.Method;

public class FilterUtils {
    public static boolean isRunnable(Method method, String[] filters) {
        ProbeTest mAnnotation = method.getAnnotation(ProbeTest.class);
        ProbeTestClass cAnnotation = method.getDeclaringClass().getAnnotation(ProbeTestClass.class);
        if (mAnnotation != null || cAnnotation != null) {
            return FilterUtils.isRunnable(new FilterTargetData(method, mAnnotation, cAnnotation), filters);
        }
        return true;
    }

    public static boolean isRunnable(Class cl, String methodName, String[] filters) {
        try {
            Method m = cl.getMethod(methodName, new Class[0]);
            return FilterUtils.isRunnable(m, filters);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return true;
        }
    }

    public static boolean isRunnable(String name, String technicalName, String key, String tags, String tickets, String[] filters) {
        return FilterUtils.isRunnable(new FilterTargetData(tags, tickets, technicalName, name, key), filters);
    }

    private static boolean isRunnable(FilterTargetData targetData, String[] filters) {
        if (filters == null || filters.length == 0) {
            return true;
        }
        for (String filter : filters) {
            String[] filterSplitted = filter.split(":");
            if (!(filterSplitted.length == 1 && targetData.anyMatch(filterSplitted[0]) || "key".equalsIgnoreCase(filterSplitted[0]) && targetData.keyMatch(filterSplitted[1]) || "name".equalsIgnoreCase(filterSplitted[0]) && targetData.nameMatch(filterSplitted[1]) || "tag".equalsIgnoreCase(filterSplitted[0]) && targetData.tagMatch(filterSplitted[1])) && (!"ticket".equalsIgnoreCase(filterSplitted[0]) || !targetData.ticketMatch(filterSplitted[1]))) continue;
            return true;
        }
        return false;
    }
}

