/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.connector;

import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.config.ServerConfiguration;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.commons.optimize.OptimizerStore;
import io.probedock.client.core.cache.CacheOptimizerStore;
import io.probedock.client.core.serializer.ProbeSerializer;
import io.probedock.client.core.serializer.json.JsonSerializer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connector.class);
    private static final String CONTENT_TYPE = "application/vnd.probe-dock.payload.v1+json";
    private static final int CONNECTION_TIMEOUT = 10000;
    private Configuration configuration;
    private ProbeSerializer serializer;
    private OptimizerStore store = null;

    public Connector(Configuration configuration) {
        this.configuration = configuration;
        this.serializer = new JsonSerializer();
    }

    public boolean send(ProbeTestRun testRun) throws MalformedURLException {
        LOGGER.info("Connected to Probe Dock API at {}", (Object)this.configuration.getServerConfiguration().getApiUrl());
        if (this.configuration.isPayloadPrint()) {
            try (OutputStreamWriter testRunOsw = new OutputStreamWriter(System.out);){
                this.serializer.serializePayload(testRunOsw, testRun, true);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.optimizeStart();
        boolean result = this.sendTestRun(this.optimize(testRun), true);
        this.optimizeStop(result);
        if (!result) {
            result = this.sendTestRun(testRun, false);
        }
        return result;
    }

    private URL getTestRunUrl() throws MalformedURLException {
        return new URL(this.configuration.getServerConfiguration().getApiUrl() + "/publish");
    }

    private boolean sendTestRun(ProbeTestRun testRun, boolean optimized) {
        block21: {
            HttpURLConnection conn = null;
            String payloadLogString = optimized ? "optimized payload" : "payload";
            try {
                conn = this.uploadTestRun(testRun);
                if (conn.getResponseCode() == 202) {
                    LOGGER.info("The {} was successfully sent to Probe Dock.", (Object)payloadLogString);
                    return true;
                }
                LOGGER.error("Unable to send the {} to Probe Dock. Return code: {}, content: {}", new Object[]{payloadLogString, conn.getResponseCode(), this.readInputStream(conn.getInputStream())});
            }
            catch (IOException ioe) {
                if (this.configuration.isPayloadPrint()) break block21;
                try (OutputStreamWriter baos = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), Charset.forName("UTF-8").newEncoder());){
                    this.serializer.serializePayload(baos, testRun, true);
                    LOGGER.error("The {} in error: {}", (Object)payloadLogString, (Object)baos.toString());
                }
                catch (IOException baosIoe) {
                    // empty catch block
                }
                if (conn != null) {
                    try {
                        if (conn.getErrorStream() != null) {
                            LOGGER.error("Unable to send the {} to Probe Dock. Error: {}", (Object)payloadLogString, (Object)this.readInputStream(conn.getErrorStream()));
                        }
                        LOGGER.error("Unable to send the " + payloadLogString + " to Probe Dock. This is probably due to an unreachable network issue.", (Throwable)ioe);
                    }
                    catch (IOException errorIoe) {
                        LOGGER.error("Unable to send the {} to Probe Dock for unknown reason.", (Object)payloadLogString);
                    }
                }
                LOGGER.error("Unable to send the {} to Probe Dock. Error: {}", (Object)payloadLogString, (Object)ioe.getMessage());
            }
        }
        return false;
    }

    private HttpURLConnection uploadTestRun(ProbeTestRun testRun) throws IOException {
        HttpURLConnection conn = this.openConnection(this.configuration.getServerConfiguration(), this.getTestRunUrl());
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/vnd.probe-dock.payload.v1+json; charset=UTF-8");
        conn.setRequestProperty("Authorization", "Bearer " + this.configuration.getServerConfiguration().getApiToken());
        conn.setConnectTimeout(10000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream(), Charset.forName("UTF-8").newEncoder());
        this.serializer.serializePayload(osw, testRun, false);
        return conn;
    }

    private String readInputStream(InputStream in) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8").newDecoder()));
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }

    private void optimizeStart() {
        if (this.configuration.isPayloadCache()) {
            if (this.configuration.getOptimizerStoreClass() == null) {
                this.store = new CacheOptimizerStore();
                this.store.start(this.configuration);
                return;
            }
            try {
                this.store = (OptimizerStore)Class.forName(this.configuration.getOptimizerStoreClass()).newInstance();
                this.store.start(this.configuration);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Unable to find the class {}. The payload will be sent without optimizations.", (Object)this.configuration.getOptimizerStoreClass());
            }
            catch (InstantiationException ex) {
                LOGGER.warn("Unable to instantiate the class {}. Concrete class required.", (Object)this.configuration.getOptimizerStoreClass());
            }
            catch (IllegalAccessException ex) {
                LOGGER.warn("Unable to instantiate the class {}. Empty constructor required.", (Object)this.configuration.getOptimizerStoreClass());
            }
        }
    }

    private ProbeTestRun optimize(ProbeTestRun payload) {
        if (this.store != null) {
            return payload.getOptimizer().optimize(this.store, payload);
        }
        return payload;
    }

    private void optimizeStop(boolean persist) {
        if (this.store != null) {
            this.store.stop(persist);
        }
    }

    private HttpURLConnection openConnection(ServerConfiguration configuration, URL url) throws IOException {
        if (configuration.hasProxyConfiguration()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(configuration.getProxyConfiguration().getHost(), configuration.getProxyConfiguration().getPort()));
            return (HttpURLConnection)url.openConnection(proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }
}

