/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.model.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.probedock.client.common.model.ProbeTestResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestResult
implements ProbeTestResult {
    @JsonProperty(value="k")
    private String key;
    @JsonProperty(value="n")
    private String name;
    @JsonProperty(value="p")
    private boolean passed;
    @JsonProperty(value="v")
    private boolean active;
    @JsonProperty(value="d")
    private long duration;
    @JsonProperty(value="m")
    private String message;
    @JsonProperty(value="c")
    private String category;
    @JsonProperty(value="g")
    private Set<String> tags;
    @JsonProperty(value="t")
    private Set<String> tickets;
    @JsonProperty(value="a")
    private Map<String, String> data;

    public TestResult() {
    }

    public TestResult(String key, String name, Long duration, boolean passed, String message, String category) {
        this.key = key;
        this.name = name;
        this.duration = duration;
        this.passed = passed;
        this.message = message;
        this.category = category;
    }

    public TestResult(String key, String name, Long duration, boolean passed, String message, String category, boolean active) {
        this.key = key;
        this.name = name;
        this.duration = duration;
        this.passed = passed;
        this.message = message;
        this.category = category;
        this.active = active;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    public void addTags(String[] tags) {
        this.addTags(Arrays.asList(tags));
    }

    public void addTags(List<String> tags) {
        this.addTags(new HashSet<String>(tags));
    }

    public void addTags(Set<String> tags) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.addAll(tags);
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
    }

    @Override
    public Set<String> getTickets() {
        return this.tickets;
    }

    public void addTickets(String[] tickets) {
        this.addTickets(Arrays.asList(tickets));
    }

    public void addTickets(List<String> tickets) {
        this.addTickets(new HashSet<String>(tickets));
    }

    public void addTickets(Set<String> tickets) {
        if (this.tickets == null) {
            this.tickets = new HashSet<String>();
        }
        this.tickets.addAll(tickets);
    }

    public void addTicket(String ticket) {
        if (this.tickets == null) {
            this.tickets = new HashSet<String>();
        }
        this.tickets.add(ticket);
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    public void addData(Map<String, String> data) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.putAll(data);
    }

    public void addData(String key, String value) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, value);
    }

    public String toString() {
        StringBuilder sbTags = new StringBuilder();
        if (this.tags != null) {
            for (String g : this.tags) {
                sbTags.append("Tag: [").append(g).append(", ");
            }
        }
        StringBuilder sbTickets = new StringBuilder();
        if (this.tickets != null) {
            for (String t : this.tickets) {
                sbTickets.append("Ticket: [").append(t).append(", ");
            }
        }
        StringBuilder sbData = new StringBuilder();
        if (this.data != null) {
            for (Map.Entry<String, String> e : this.data.entrySet()) {
                sbData.append("Data[Key: [").append(e.getKey()).append("], Value: [").append(e.getValue()).append("], ");
            }
        }
        return "TestResult: [Key: " + this.key + ", " + "Name: " + this.name + ", " + "Passed: " + this.passed + ", " + "Active: " + this.active + ", " + "Duration: " + this.duration + ", " + "Message: " + this.message + ", " + "Category: " + this.category + ", " + "Status: " + this.active + ", " + "Tags: [" + sbTags.toString().replaceAll(", $", "]") + "], " + "Tickets: [" + sbTickets.toString().replaceAll(", $", "]") + "], " + "Data: [" + sbData.toString().replaceAll(", $", "") + "]" + "]";
    }
}

