/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.common.config.ProbeConfigurationException;
import io.probedock.client.common.config.ProxyConfiguration;
import io.probedock.client.common.utils.FootprintGenerator;
import java.util.Map;

public class ServerConfiguration {
    private String name;
    private String apiUrl;
    private String apiToken;
    private String projectApiId;
    private ProxyConfiguration proxyConfiguration;

    public ServerConfiguration(String name) {
        this.name = name;
    }

    public void configureWith(Map<String, Object> data) {
        this.apiUrl = this.configureString(this.apiUrl, data, "apiUrl");
        this.apiToken = this.configureString(this.apiToken, data, "apiToken");
        this.projectApiId = this.configureString(this.projectApiId, data, "projectApiId");
        if (data.containsKey("proxy")) {
            this.proxyConfiguration = new ProxyConfiguration();
            if (data.get("proxy") instanceof Map) {
                this.proxyConfiguration.configureWith((Map)data.get("proxy"));
            } else {
                throw new ProbeConfigurationException("Unable to parse the proxy configuration for server: " + this.name);
            }
        }
    }

    public String getBaseUrlFootprint() {
        return FootprintGenerator.footprint(this.apiUrl);
    }

    public boolean isValid() {
        return this.apiUrl != null && this.apiToken != null;
    }

    public String getName() {
        return this.name;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public String getProjectApiId() {
        return this.projectApiId;
    }

    public boolean hasProxyConfiguration() {
        return this.proxyConfiguration != null;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    private String configureString(String previousValue, Map<String, Object> data, String key) {
        Object value = data.get(key);
        return value != null ? value.toString() : previousValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name: \"").append(this.name).append("\"");
        builder.append(", apiUrl: \"").append(this.apiUrl).append("\"");
        builder.append(", apiToken: \"").append(this.apiToken).append("\"");
        builder.append(", projectApiId: \"").append(this.projectApiId).append("\"");
        if (this.proxyConfiguration != null) {
            builder.append(", proxy: \"").append(this.proxyConfiguration).append("\"");
        }
        return builder.toString();
    }
}

