/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.common.config.ProbeConfigurationException;
import java.util.Map;

public class ProxyConfiguration {
    private String host;
    private int port;

    public void configureWith(Map<String, Object> data) {
        this.host = this.configureString(this.host, data, "host");
        this.port = this.configureInt(this.port, data, "port");
    }

    public boolean isValid() {
        return this.port > 0 && this.port < 65536 && this.host != null && !this.host.isEmpty();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private String configureString(String previousValue, Map<String, Object> data, String key) {
        Object value = data.get(key);
        return value != null ? value.toString() : previousValue;
    }

    private int configureInt(int previousValue, Map<String, Object> data, String key) {
        if (data.get(key) instanceof Integer) {
            Integer value = (Integer)data.get(key);
            return value > 0 && value < 65536 ? value : previousValue;
        }
        throw new ProbeConfigurationException("The " + key + "[" + data.get(key) + "] is not an integer.");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("host: \"").append(this.host).append("\"");
        builder.append(", port: \"").append(this.port).append("\"");
        return builder.toString();
    }
}

