/*
 * Decompiled with CFR 0.152.
 */
package io.potter.thrift.maven;

import com.google.common.collect.ImmutableList;
import io.potter.thrift.maven.AbstractThriftMojo;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="compile", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public final class ThriftCompileMojo
extends AbstractThriftMojo {
    @Parameter(defaultValue="${basedir}/src/main/thrift", required=true)
    private File thriftSourceRoot;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/thrift", required=true)
    private File outputDirectory;

    @Override
    protected List<Artifact> getDependencyArtifacts() {
        List compileArtifacts = this.project.getCompileArtifacts();
        return compileArtifacts;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getThriftSourceRoot() {
        return this.thriftSourceRoot;
    }

    @Override
    protected void attachFiles() {
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        this.projectHelper.addResource(this.project, this.thriftSourceRoot.getAbsolutePath(), (List)ImmutableList.of((Object)"**/*.thrift"), (List)ImmutableList.of());
    }
}

