/*
 * Decompiled with CFR 0.152.
 */
package io.potter.thrift.maven;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.potter.thrift.maven.Thrift;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

public abstract class AbstractThriftMojo
extends AbstractMojo {
    private static final String THRIFT_FILE_SUFFIX = ".thrift";
    private static final String DEFAULT_INCLUDES = "**/*.thrift";
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    ArtifactResolver artifactResolver;
    @Component
    RepositorySystem repositorySystem;
    @Component
    ResolutionErrorHandler resolutionErrorHandler;
    @Parameter(defaultValue="")
    private String thriftExecutable;
    @Parameter(defaultValue="")
    private String thriftArtifact;
    @Parameter(defaultValue="java:hashcode")
    private String generator;
    @Parameter
    private File[] additionalThriftPathElements = new File[0];
    @Parameter(defaultValue="${project.build.directory}/thrift-dependencies", required=true)
    private File temporaryThriftFileDirectory;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}/thrift-plugins")
    private File thriftPluginDirectory;
    @Parameter(defaultValue="true", required=true)
    private boolean hashDependentPaths;
    @Parameter
    private Set<String> includes = ImmutableSet.of((Object)"**/*.thrift");
    @Parameter
    private Set<String> excludes = ImmutableSet.of();
    @Parameter
    private long staleMillis = 0L;
    @Parameter
    private boolean checkStaleness = false;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParameters();
        File thriftSourceRoot = this.getThriftSourceRoot();
        if (thriftSourceRoot.exists()) {
            try {
                Thrift thrift;
                int exitStatus;
                ImmutableSet<File> thriftFiles = this.findThriftFilesInDirectory(thriftSourceRoot);
                File outputDirectory = this.getOutputDirectory();
                ImmutableSet<File> outputFiles = this.findGeneratedFilesInDirectory(this.getOutputDirectory());
                if (thriftFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No thrift files to compile.");
                }
                if (this.checkStaleness && this.lastModified(thriftFiles) + this.staleMillis < this.lastModified(outputFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because target directory newer than sources.");
                    this.attachFiles();
                }
                ImmutableSet<File> derivedThriftPathElements = this.makeThriftPathFromJars(this.temporaryThriftFileDirectory, (Iterable<File>)this.getDependencyArtifactFiles());
                FileUtils.forceMkdir((File)outputDirectory);
                FileUtils.cleanDirectory((File)outputDirectory);
                if (this.thriftExecutable == null && this.thriftArtifact != null) {
                    Artifact artifact = this.createDependencyArtifact(this.thriftArtifact);
                    File file = this.resolveBinaryArtifact(artifact);
                    this.thriftExecutable = file.getAbsolutePath();
                }
                if (this.thriftExecutable == null) {
                    this.getLog().warn((CharSequence)"No 'thriftExecutable' parameter is configured, using the default: 'thrift'");
                    this.thriftExecutable = "thrift";
                }
                if ((exitStatus = (thrift = new Thrift.Builder(this.thriftExecutable, outputDirectory).setGenerator(this.generator).addThriftPathElement(thriftSourceRoot).addThriftPathElements((Iterable<File>)derivedThriftPathElements).addThriftPathElements(Arrays.asList(this.additionalThriftPathElements)).addThriftFiles((Iterable<File>)thriftFiles).build()).compile()) != 0) {
                    this.getLog().error((CharSequence)("thrift failed output: " + thrift.getOutput()));
                    this.getLog().error((CharSequence)("thrift failed error: " + thrift.getError()));
                    throw new MojoFailureException("thrift did not exit cleanly. Review output for more information.");
                }
                this.attachFiles();
            }
            catch (IOException e) {
                throw new MojoFailureException("An IO error occured", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("thrift failed to execute because: " + e.getMessage(), (Throwable)e);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("An error occurred while invoking thrift.", (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)String.format("%s does not exist. Review the configuration or consider disabling the plugin.", thriftSourceRoot));
        }
    }

    private ImmutableSet<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return ImmutableSet.of();
        }
        List javaFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*.java", null);
        return ImmutableSet.copyOf((Collection)javaFilesInDirectory);
    }

    private long lastModified(ImmutableSet<File> files) {
        long result = 0L;
        for (File file : files) {
            if (file.lastModified() <= result) continue;
            result = file.lastModified();
        }
        return result;
    }

    private void checkParameters() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project missing");
        Preconditions.checkNotNull((Object)this.projectHelper, (Object)"projectHelper missing");
        Preconditions.checkNotNull((Object)this.artifactFactory, (Object)"artifactFactory missing");
        Preconditions.checkNotNull((Object)this.artifactResolver, (Object)"artifactResolver missing");
        Preconditions.checkNotNull((Object)this.repositorySystem, (Object)"repositorySystem missing");
        Preconditions.checkNotNull((Object)this.resolutionErrorHandler, (Object)"resolutionErrorHandler missing");
        Preconditions.checkArgument((this.thriftExecutable != null || this.thriftArtifact != null ? 1 : 0) != 0, (Object)"thriftExecutable or thriftArtifact missing");
        Preconditions.checkNotNull((Object)this.generator, (Object)"generator missing");
        File thriftSourceRoot = this.getThriftSourceRoot();
        Preconditions.checkNotNull((Object)thriftSourceRoot);
        Preconditions.checkArgument((!thriftSourceRoot.isFile() ? 1 : 0) != 0, (Object)"thriftSourceRoot is a file, not a diretory");
        Preconditions.checkNotNull((Object)this.temporaryThriftFileDirectory, (Object)"temporaryThriftFileDirectory missing");
        Preconditions.checkState((!this.temporaryThriftFileDirectory.isFile() ? 1 : 0) != 0, (Object)"temporaryThriftFileDirectory is a file, not a directory");
        File outputDirectory = this.getOutputDirectory();
        Preconditions.checkNotNull((Object)outputDirectory);
        Preconditions.checkState((!outputDirectory.isFile() ? 1 : 0) != 0, (Object)"the outputDirectory is a file, not a directory");
    }

    protected abstract File getThriftSourceRoot();

    protected abstract List<Artifact> getDependencyArtifacts();

    protected abstract File getOutputDirectory();

    protected abstract void attachFiles();

    private ImmutableSet<File> getDependencyArtifactFiles() {
        HashSet dependencyArtifactFiles = Sets.newHashSet();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            dependencyArtifactFiles.add(artifact.getFile());
        }
        return ImmutableSet.copyOf((Collection)dependencyArtifactFiles);
    }

    private ImmutableSet<File> makeThriftPathFromJars(File temporaryThriftFileDirectory, Iterable<File> classpathElementFiles) throws IOException, MojoExecutionException {
        Preconditions.checkNotNull(classpathElementFiles, (Object)"classpathElementFiles");
        if (temporaryThriftFileDirectory.exists()) {
            FileUtils.cleanDirectory((File)temporaryThriftFileDirectory);
        }
        HashSet thriftDirectories = Sets.newHashSet();
        for (File classpathElementFile : classpathElementFiles) {
            File[] thriftFiles;
            if (classpathElementFile.isFile() && classpathElementFile.canRead() && !classpathElementFile.getName().endsWith(".xml")) {
                JarFile classpathJar;
                try {
                    classpathJar = new JarFile(classpathElementFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("%s was not a readable artifact", classpathElementFile));
                }
                for (JarEntry jarEntry : Collections.list(classpathJar.entries())) {
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntry.getName().endsWith(THRIFT_FILE_SUFFIX)) continue;
                    File uncompressedCopy = new File(new File(temporaryThriftFileDirectory, this.truncatePath(classpathJar.getName())), jarEntryName);
                    uncompressedCopy.getParentFile().mkdirs();
                    FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(classpathJar.getInputStream(jarEntry)), (File)uncompressedCopy);
                    thriftDirectories.add(uncompressedCopy.getParentFile());
                }
                continue;
            }
            if (!classpathElementFile.isDirectory() || (thriftFiles = classpathElementFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(AbstractThriftMojo.THRIFT_FILE_SUFFIX);
                }
            })).length <= 0) continue;
            thriftDirectories.add(classpathElementFile);
        }
        return ImmutableSet.copyOf((Collection)thriftDirectories);
    }

    private ImmutableSet<File> findThriftFilesInDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object)directory);
        Joiner joiner = Joiner.on((char)',');
        List thriftFilesInDirectory = FileUtils.getFiles((File)directory, (String)joiner.join(this.includes), (String)joiner.join(this.excludes));
        return ImmutableSet.copyOf((Collection)thriftFilesInDirectory);
    }

    ImmutableSet<File> findThriftFilesInDirectories(Iterable<File> directories) throws IOException {
        Preconditions.checkNotNull(directories);
        HashSet thriftFiles = Sets.newHashSet();
        for (File directory : directories) {
            thriftFiles.addAll(this.findThriftFilesInDirectory(directory));
        }
        return ImmutableSet.copyOf((Collection)thriftFiles);
    }

    String truncatePath(String jarPath) throws MojoExecutionException {
        int colonIndex;
        String path;
        int repositoryIndex;
        if (this.hashDependentPaths) {
            try {
                return AbstractThriftMojo.toHexString(MessageDigest.getInstance("MD5").digest(jarPath.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new MojoExecutionException("Failed to expand dependent jar", (Exception)e);
            }
        }
        String repository = this.localRepository.getBasedir().replace('\\', '/');
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        if ((repositoryIndex = (path = jarPath.replace('\\', '/')).indexOf(repository)) != -1) {
            path = path.substring(repositoryIndex + repository.length());
        }
        if ((colonIndex = path.indexOf(58)) != -1) {
            path = path.substring(colonIndex + 2);
        }
        return path;
    }

    private static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hexString.toString();
    }

    private File resolveBinaryArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactResolutionResult result;
        try {
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setResolveTransitively(false).setArtifactDependencies(Collections.singleton(artifact)).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setOffline(this.session.isOffline()).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
            result = this.repositorySystem.resolve(request);
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Set artifacts = result.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            throw new MojoExecutionException("Unable to resolve plugin artifact");
        }
        Artifact resolvedBinaryArtifact = (Artifact)artifacts.iterator().next();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved artifact: " + resolvedBinaryArtifact));
        }
        File sourceFile = resolvedBinaryArtifact.getFile();
        String sourceFileName = sourceFile.getName();
        String targetFileName = Os.isFamily((String)"windows") && !sourceFileName.endsWith(".exe") ? sourceFileName + ".exe" : sourceFileName;
        File targetFile = new File(this.thriftPluginDirectory, targetFileName);
        if (targetFile.exists()) {
            this.getLog().debug((CharSequence)("Executable file already exists: " + targetFile.getAbsolutePath()));
            return targetFile;
        }
        try {
            FileUtils.forceMkdir((File)this.thriftPluginDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create directory " + this.thriftPluginDirectory, (Exception)e);
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy the file to " + this.thriftPluginDirectory, (Exception)e);
        }
        if (!Os.isFamily((String)"windows")) {
            targetFile.setExecutable(true);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executable file: " + targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    private Artifact createDependencyArtifact(String artifactSpec) throws MojoExecutionException {
        String[] parts = artifactSpec.split(":");
        if (parts.length < 3 || parts.length > 5) {
            throw new MojoExecutionException("Invalid artifact specification format, expected: groupId:artifactId:version[:type[:classifier]], actual: " + artifactSpec);
        }
        String type = parts.length >= 4 ? parts[3] : "exe";
        String classifier = parts.length == 5 ? parts[4] : null;
        return this.createDependencyArtifact(parts[0], parts[1], parts[2], type, classifier);
    }

    private Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        VersionRange versionSpec;
        try {
            versionSpec = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid version specification", (Exception)((Object)e));
        }
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionSpec, type, classifier, "runtime");
    }
}

