/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask.parsers;

import com.google.inject.Inject;
import io.polygonal.Logger;
import io.polygonal.Message;
import io.polygonal.verifytask.dto.PackageInformation;
import io.polygonal.verifytask.dto.ProjectLanguage;
import io.polygonal.verifytask.ports.PackageParser;
import io.polygonal.verifytask.ports.SourceCodeParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Set;

class PackageDirectoryParser
implements PackageParser {
    private static final String SOURCE_CODE_PARSER_ERROR = "";
    private final SourceCodeParser sourceCodeParser;

    @Inject
    public PackageDirectoryParser(ProjectLanguage projectLanguage, Set<SourceCodeParser> parsers) {
        this.sourceCodeParser = parsers.stream().filter(parser -> parser.test(projectLanguage.getLanguage())).findFirst().orElseThrow(IllegalStateException::new);
    }

    @Override
    public PackageInformation parseDirectory(File packageDir) {
        PackageInformation information = new PackageInformation();
        Files.list(packageDir.toPath()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            Logger.log.debug(Message.PARSING_SOURCE_CODE_FOR_FILE.withArgs(path.getFileName()), new Object[0]);
            try (BufferedReader reader = Files.newBufferedReader(path);){
                this.sourceCodeParser.processSingleFile(reader, information);
            }
            catch (IOException e) {
                Logger.log.error(Message.SOURCE_CODE_PARSER_ERROR.withArgs(path.getFileName()), e);
            }
        });
        return information;
    }
}

