/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import com.google.inject.Inject;
import io.polygonal.Message;
import io.polygonal.plugin.PackageDef;
import io.polygonal.verifytask.DefaultDataDecorator;
import io.polygonal.verifytask.DirectoryToPackageNameConverter;
import io.polygonal.verifytask.PackagesIntoMapSplitter;
import io.polygonal.verifytask.dto.ProjectLanguage;
import io.polygonal.verifytask.ports.PackagesVerifier;
import io.polygonal.verifytask.ports.SinglePackageVerifier;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RecursivePackagesVerifier
implements PackagesVerifier {
    private final SinglePackageVerifier singlePackageVerifier;

    @Inject
    RecursivePackagesVerifier(ProjectLanguage projectLanguage, Set<SinglePackageVerifier> verifiers) {
        this.singlePackageVerifier = verifiers.stream().filter(verifier -> verifier.test(projectLanguage.getLanguage())).findFirst().orElseThrow(IllegalStateException::new);
    }

    @Override
    public void verify(File basePackageDir, List<PackageDef> defExtensions) {
        if (!basePackageDir.isDirectory()) {
            throw new IllegalArgumentException(Message.BASE_PACKAGE_DOESNT_EXIST.withArgs(basePackageDir.getPath()));
        }
        DefaultDataDecorator.decorateWithDefaultData(defExtensions);
        Map<File, PackageDef> definitionsMap = PackagesIntoMapSplitter.splitPackagesIntoMap(basePackageDir, defExtensions);
        this.singlePackageVerifier.verify(basePackageDir, definitionsMap.get(basePackageDir));
        Files.list(basePackageDir.toPath()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
            PackageDef packageDefExtension = definitionsMap.getOrDefault(path.toFile(), new PackageDef(DirectoryToPackageNameConverter.convertToPackageName(basePackageDir, path.toFile())));
            this.singlePackageVerifier.verify(path.toFile(), packageDefExtension);
        });
    }
}

