/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask.verifiers;

import io.polygonal.verifytask.parsers.PackageParserFactory;
import io.polygonal.verifytask.verifiers.BasicPackageVerifier;
import io.polygonal.verifytask.verifiers.KotlinPackageVerifier;
import io.polygonal.verifytask.verifiers.PackageVerifier;

public class PackageVerifierFactory {
    public static final String JAVA = "java";
    public static final String KOTLIN = "kotlin";

    private PackageVerifierFactory() {
    }

    public static PackageVerifier forLanguage(String language) {
        switch (language) {
            case "java": {
                return new BasicPackageVerifier(PackageParserFactory.forLanguage(language));
            }
            case "kotlin": {
                return new KotlinPackageVerifier(PackageParserFactory.forLanguage(language));
            }
        }
        throw new IllegalArgumentException();
    }
}

