/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask.parsers;

import io.polygonal.verifytask.PackageInformation;
import io.polygonal.verifytask.parsers.PackageParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;

abstract class PackageObjectsProcessor
implements PackageParser {
    PackageObjectsProcessor() {
    }

    @Override
    public PackageInformation parse(File packageDir) {
        PackageInformation information = new PackageInformation();
        Files.list(packageDir.toPath()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                this.processSingleFile(reader, information);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        return information;
    }

    protected abstract void processSingleFile(BufferedReader var1, PackageInformation var2);
}

