/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask.parsers;

import io.polygonal.verifytask.PackageInformation;
import io.polygonal.verifytask.parsers.PackageObjectsProcessor;
import java.io.BufferedReader;
import java.util.regex.Pattern;

class KotlinPackageParser
extends PackageObjectsProcessor {
    private static final String ALL_TYPES = "(class|interface|abstract class|enum class|data class|open class)\\s*";
    private static final String ALL_SCOPES = "(private|internal|[a]*)";
    private static final Pattern INTERNAL_OBJECTS_PATTERN = Pattern.compile("^internal (class|interface|abstract class|enum class|data class|open class)\\s*");
    private static final Pattern PRIVATE_OBJECTS_PATTERN = Pattern.compile("^private (class|interface|abstract class|enum class|data class|open class)\\s*");
    private static final Pattern CLASSES_PATTERN = Pattern.compile("^(private|internal|[a]*)\\s*class");
    private static final Pattern DATA_CLASSES_PATTERN = Pattern.compile("^(private|internal|[a]*)\\s*data class");
    private static final Pattern OPEN_CLASSES_PATTERN = Pattern.compile("^(private|internal|[a]*)\\s*open class");
    private static final Pattern INTERFACES_PATTERN = Pattern.compile("^(private|internal|[a]*)\\s*interface");
    private static final Pattern ABSTRACT_CLASS_PATTERN = Pattern.compile("^(private|internal|[a]*)\\s*abstract class");
    private static final Pattern ENUM_PATTERN = Pattern.compile("^(private|internal|[a]*)\\s*enum");

    KotlinPackageParser() {
    }

    @Override
    protected void processSingleFile(BufferedReader reader, PackageInformation information) {
        String text;
        boolean scopeFound = false;
        boolean typeFound = false;
        while ((text = reader.readLine()) != null) {
            if (!scopeFound && !PRIVATE_OBJECTS_PATTERN.matcher(text).find()) {
                if (INTERNAL_OBJECTS_PATTERN.matcher(text).find()) {
                    information.incInternalObjects();
                    scopeFound = true;
                } else if (typeFound) {
                    information.incPublicObjects();
                    scopeFound = true;
                }
            }
            if (!typeFound) {
                if (CLASSES_PATTERN.matcher(text).find()) {
                    information.incClasses();
                    typeFound = true;
                }
                if (DATA_CLASSES_PATTERN.matcher(text).find()) {
                    information.incDataClasses();
                    typeFound = true;
                }
                if (OPEN_CLASSES_PATTERN.matcher(text).find()) {
                    information.incOpenClasses();
                    typeFound = true;
                }
                if (INTERFACES_PATTERN.matcher(text).find()) {
                    information.incInterfaces();
                    typeFound = true;
                }
                if (ABSTRACT_CLASS_PATTERN.matcher(text).find()) {
                    information.incAbstractClasses();
                    typeFound = true;
                }
                if (ENUM_PATTERN.matcher(text).find()) {
                    information.incEnums();
                    typeFound = true;
                }
            }
            if (!scopeFound || !typeFound) continue;
            break;
        }
    }
}

