/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask.parsers;

import io.polygonal.verifytask.PackageInformation;
import io.polygonal.verifytask.parsers.PackageObjectsProcessor;
import java.io.BufferedReader;
import java.util.regex.Pattern;

class JavaPackageParser
extends PackageObjectsProcessor {
    private static final String ALL_TYPES = "(class|interface|abstract class|enum)\\s*";
    private static final String ALL_SCOPES = "(public|protected|[a]*)";
    private static final Pattern PUBLIC_OBJECTS_PATTERN = Pattern.compile("^public (class|interface|abstract class|enum)\\s*");
    private static final Pattern PROTECTED_OBJECTS_PATTERN = Pattern.compile("^protected (class|interface|abstract class|enum)\\s*");
    private static final Pattern CLASSES_PATTERN = Pattern.compile("^(public|protected|[a]*)\\s*class");
    private static final Pattern INTERFACES_PATTERN = Pattern.compile("^(public|protected|[a]*)\\s*interface");
    private static final Pattern ABSTRACT_CLASS_PATTERN = Pattern.compile("^(public|protected|[a]*)\\s*abstract class");
    private static final Pattern ENUM_PATTERN = Pattern.compile("^(public|protected|[a]*)\\s*enum");

    JavaPackageParser() {
    }

    @Override
    protected void processSingleFile(BufferedReader reader, PackageInformation information) {
        String text;
        boolean scopeFound = false;
        boolean typeFound = false;
        while ((text = reader.readLine()) != null) {
            if (!scopeFound) {
                if (PUBLIC_OBJECTS_PATTERN.matcher(text).find()) {
                    information.incPublicObjects();
                    scopeFound = true;
                } else if (PROTECTED_OBJECTS_PATTERN.matcher(text).find()) {
                    information.incProtectedObjects();
                    scopeFound = true;
                } else if (typeFound) {
                    information.incPackagePrivateObjects();
                    scopeFound = true;
                }
            }
            if (!typeFound) {
                if (CLASSES_PATTERN.matcher(text).find()) {
                    information.incClasses();
                    typeFound = true;
                }
                if (INTERFACES_PATTERN.matcher(text).find()) {
                    information.incInterfaces();
                    typeFound = true;
                }
                if (ABSTRACT_CLASS_PATTERN.matcher(text).find()) {
                    information.incAbstractClasses();
                    typeFound = true;
                }
                if (ENUM_PATTERN.matcher(text).find()) {
                    information.incEnums();
                    typeFound = true;
                }
            }
            if (!scopeFound || !typeFound) continue;
            break;
        }
    }
}

