/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ObjectHelper {
    private ObjectHelper() {
    }

    static <T> T merge(T src, T target) {
        Field[] fields;
        for (Field field : fields = src.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(src);
            try {
                Field targetField = target.getClass().getDeclaredField(field.getName());
                targetField.setAccessible(true);
                targetField.set(target, value);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return target;
    }

    static void set(Object target, String property, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(property);
            field.setAccessible(true);
            if (value instanceof List && field.getType().isAssignableFrom(Set.class)) {
                value = new HashSet((List)((Object)value));
            }
            field.set(target, value);
        }
        catch (NoSuchFieldException field) {}
    }

    static void set(Object target, Map<String, Object> properties) {
        properties.forEach((key, value) -> ObjectHelper.set(target, key, value));
    }
}

