/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import io.polygonal.Message;
import io.polygonal.plugin.PackageDef;
import io.polygonal.verifytask.DefaultDataDecorator;
import io.polygonal.verifytask.DirectoryToPackageConverter;
import io.polygonal.verifytask.PackagesSplitter;
import io.polygonal.verifytask.verifiers.PackageVerifier;
import io.polygonal.verifytask.verifiers.PackageVerifierFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;

class RecursivePackagesVerifier {
    private static final DefaultDataDecorator defaultDataDecorator = new DefaultDataDecorator();
    private final String language;

    RecursivePackagesVerifier(String language) {
        this.language = language;
    }

    public void verify(File basePackageDir, List<PackageDef> defExtensions) {
        if (!basePackageDir.isDirectory()) {
            throw new IllegalArgumentException(Message.BASE_PACKAGE_DOESNT_EXIST.withArgs(basePackageDir.getPath()));
        }
        PackageVerifier packageVerifier = PackageVerifierFactory.forLanguage(this.language);
        defExtensions = defaultDataDecorator.decorate(defExtensions);
        Map<File, PackageDef> definitionsMap = PackagesSplitter.walkAndSplit(basePackageDir, defExtensions);
        packageVerifier.verify(basePackageDir, definitionsMap.get(basePackageDir));
        Files.list(basePackageDir.toPath()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
            PackageDef packageDefExtension = definitionsMap.getOrDefault(path.toFile(), new PackageDef(DirectoryToPackageConverter.convert(basePackageDir, path.toFile())));
            packageVerifier.verify(path.toFile(), packageDefExtension);
        });
    }
}

