/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import io.polygonal.Message;
import io.polygonal.plugin.PackageDef;
import io.polygonal.plugin.Polygon;
import io.polygonal.verifytask.Conditions;
import io.polygonal.verifytask.MapToPackageDefConverter;
import io.polygonal.verifytask.ObjectHelper;
import io.polygonal.verifytask.TypesValidator;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

class PackagesYmlParser {
    private static final String POLYGON_EXTENSION = "polygon";
    private static final String PACKAGES = "packages";
    private static final String YML_EXTENSION = ".yml";
    static final Map<String, String> keywordsMap = new LinkedHashMap<String, String>(7);

    PackagesYmlParser() {
    }

    public Polygon parseYml(File file) {
        if (file == null || !file.exists() || !Files.isReadable(file.toPath())) {
            throw new IllegalArgumentException(Message.YML_TEMPLATE_NOT_FOUND.withArgs(file != null ? file.getPath() : ""));
        }
        if (!file.getName().endsWith(YML_EXTENSION)) {
            throw new IllegalArgumentException(Message.TEMPLATE_IS_NOT_YML_FILE.withArgs(file.getName()));
        }
        ArrayList<PackageDef> extensions = new ArrayList<PackageDef>();
        MapToPackageDefConverter mapConverter = new MapToPackageDefConverter();
        Yaml yaml = new Yaml();
        Map ymlMap = (Map)yaml.loadAs(new String(Files.readAllBytes(file.toPath())), Map.class);
        Conditions.check(ymlMap.containsKey(POLYGON_EXTENSION), Message.TEMPLATE_CANNOT_FIND_POLYGON.withArgs(POLYGON_EXTENSION, file.getName()));
        Map polygonMap = (Map)ymlMap.get(POLYGON_EXTENSION);
        PackageDef rootPackageDef = new PackageDef("");
        polygonMap.forEach((key, value) -> {
            if (keywordsMap.containsKey(key)) {
                ObjectHelper.set(rootPackageDef, keywordsMap.get(key), value);
            }
        });
        TypesValidator.validate(rootPackageDef.getTypes());
        extensions.add(rootPackageDef);
        if (polygonMap.containsKey(PACKAGES)) {
            Conditions.check(polygonMap.get(PACKAGES) instanceof Map, Message.TEMPLATE_PACKAGES_SHOULD_CONTAIN_PACKAGES_DEFINITIONS.toString());
            List<PackageDef> packagesDefinitions = mapConverter.convert((Map)polygonMap.get(PACKAGES), keywordsMap);
            extensions.addAll(packagesDefinitions);
        }
        return new Polygon(extensions);
    }

    static {
        keywordsMap.put("public", "publicScope");
        keywordsMap.put("packagePrivate", "packagePrivateScope");
        keywordsMap.put("protected", "protectedScope");
        keywordsMap.put("internal", "internalScope");
        keywordsMap.put("types", "types");
        keywordsMap.put("required", "required");
        keywordsMap.put("name", "name");
    }
}

