/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import io.polygonal.plugin.PackageDef;
import io.polygonal.verifytask.DirectoryToPackageConverter;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class PackagesSplitter {
    private PackagesSplitter() {
    }

    static Map<File, PackageDef> walkAndSplit(File rootLevel, List<PackageDef> packageDefExtensions) {
        HashMap<File, PackageDef> defExtensionMap = new HashMap<File, PackageDef>();
        if (packageDefExtensions.isEmpty()) {
            return defExtensionMap;
        }
        ArrayList<PackageDef> sourcePackageDefExtensions = new ArrayList<PackageDef>(packageDefExtensions);
        Optional<PackageDef> rootLevelDef = sourcePackageDefExtensions.stream().filter(packageDef -> "".equals(packageDef.getName())).findAny();
        if (rootLevelDef.isPresent()) {
            defExtensionMap.put(rootLevel, rootLevelDef.get());
        }
        Files.walk(rootLevel.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dir -> {
            String baseName = DirectoryToPackageConverter.convert(rootLevel, dir.toFile());
            Optional<PackageDef> packageDef = sourcePackageDefExtensions.stream().filter(p -> baseName.equals(p.getName())).findAny();
            if (packageDef.isPresent()) {
                defExtensionMap.put(dir.toFile(), packageDef.get());
            }
        });
        return defExtensionMap;
    }
}

