/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.security;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.Subject;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class DefaultAuthToken
extends AbstractAuthenticationToken {
    private final Object principal;
    private final Object credentials;

    public DefaultAuthToken(Subject subject, String credentials, Collection<GrantedAuthority> authorities) {
        super(authorities);
        super.setAuthenticated(true);
        this.principal = subject;
        this.credentials = credentials;
    }

    public String userId() {
        return this.subject().username;
    }

    public Subject subject() {
        return (Subject)this.principal;
    }

    public AuthHeader authHeader() {
        return AuthHeader.authHeader((Object)this.credentials);
    }

    public String logoutToken() {
        return ((String)this.credentials).substring(7);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return this.credentials;
    }
}

