/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.elastic;

import io.polyglotted.common.model.AuthToken;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.spring.elastic.ElasticAuthFilter;
import io.polyglotted.spring.elastic.ElasticProcessor;
import io.polyglotted.spring.errorhandling.ExceptionFactory;
import io.polyglotted.spring.web.SimpleResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ElasticLoginController {
    private static final Logger log = LoggerFactory.getLogger(ElasticLoginController.class);
    @Autowired
    private ElasticProcessor elasticProcessor = null;

    @PostMapping(path={"/elastic/login"}, params={"userId", "password"}, produces={"application/json"})
    public AuthToken login(String userId, String password) throws IOException {
        ExceptionFactory.checkBadRequest(StrUtil.notNullOrEmpty((String)userId) && StrUtil.notNullOrEmpty((String)password), "Invalid credentials.");
        try {
            return this.elasticProcessor.login(userId, password);
        }
        catch (ElasticAuthFilter.ElasticClientException ex) {
            log.debug("not found or invalid creds: {}", (Object)userId);
            throw ExceptionFactory.unauthorisedException(StrUtil.safePrefix((String)ex.getMessage(), (String)" ("));
        }
    }

    @PostMapping(path={"/elastic/logout"}, produces={"application/json"})
    public SimpleResponse logout(@RequestBody AuthToken result) throws IOException {
        this.elasticProcessor.logout(result.accessToken);
        return new SimpleResponse("logged-out");
    }
}

