/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.cognito;

import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProvider;
import com.amazonaws.services.cognitoidp.model.AdminInitiateAuthRequest;
import com.amazonaws.services.cognitoidp.model.AdminInitiateAuthResult;
import com.amazonaws.services.cognitoidp.model.AuthFlowType;
import com.amazonaws.services.cognitoidp.model.AuthenticationResultType;
import com.amazonaws.services.cognitoidp.model.GlobalSignOutRequest;
import com.amazonaws.services.cognitoidp.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidp.model.UserNotFoundException;
import io.polyglotted.common.model.AuthToken;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.spring.cognito.AbstractCognito;
import io.polyglotted.spring.errorhandling.ExceptionFactory;
import io.polyglotted.spring.web.SimpleResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CognitoLoginController
extends AbstractCognito {
    private static final Logger log = LoggerFactory.getLogger(CognitoLoginController.class);

    @Autowired
    public CognitoLoginController(AbstractCognito.CognitoConfig config, AWSCognitoIdentityProvider cognitoClient) {
        super(config, cognitoClient);
    }

    @PostMapping(path={"/cognito/login"}, params={"email", "password"}, produces={"application/json"})
    public AuthenticationResultType login(String email, String password) throws IOException {
        ExceptionFactory.checkBadRequest(StrUtil.notNullOrEmpty((String)email) && StrUtil.notNullOrEmpty((String)password), "Invalid credentials.");
        try {
            AdminInitiateAuthRequest authRequest = new AdminInitiateAuthRequest().withAuthFlow(AuthFlowType.ADMIN_NO_SRP_AUTH).withAuthParameters(MapBuilder.simpleMap((Object)"USERNAME", (Object)email, (Object)"PASSWORD", (Object)password, (Object)"SECRET_HASH", (Object)this.config.getClientSecret())).withClientId(this.config.getClientId()).withUserPoolId(this.config.getUserPoolId());
            AdminInitiateAuthResult authResponse = this.cognitoClient.adminInitiateAuth(authRequest);
            if (StrUtil.nullOrEmpty((String)authResponse.getChallengeName())) {
                return authResponse.getAuthenticationResult();
            }
            throw ExceptionFactory.unauthorisedException("Unexpected challenge on signin: " + authResponse.getChallengeName() + ".");
        }
        catch (NotAuthorizedException | UserNotFoundException ex) {
            log.debug("not found or invalid creds: {}", (Object)email);
            throw ExceptionFactory.unauthorisedException(StrUtil.safePrefix((String)ex.getMessage(), (String)" ("));
        }
    }

    @PostMapping(path={"/cognito/logout"}, produces={"application/json"})
    public SimpleResponse logout(@RequestBody AuthToken result) throws IOException {
        this.cognitoClient.globalSignOut(new GlobalSignOutRequest().withAccessToken(result.accessToken));
        return new SimpleResponse("logged-out");
    }
}

