/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.errorhandling;

import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.spring.errorhandling.ExceptionFactory;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order(value=-2147483648)
@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={ExceptionFactory.NotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(ExceptionFactory.NotFoundException ex, WebRequest request) {
        return RestExceptionHandler.resultEntity(ex.getMessage(), HttpStatus.NOT_FOUND, request);
    }

    @ExceptionHandler(value={ExceptionFactory.WebException.class})
    protected ResponseEntity<Object> handleWebException(ExceptionFactory.WebException ex, WebRequest request) {
        return RestExceptionHandler.resultEntity(ex.getMessage(), ex.status, request);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    protected ResponseEntity<Object> handleAccessDeniedException(AccessDeniedException ex, WebRequest request) {
        return RestExceptionHandler.resultEntity("User is not authorised to perform action.", HttpStatus.FORBIDDEN, request);
    }

    private static ResponseEntity<Object> resultEntity(String message, HttpStatus status, WebRequest request) {
        return new ResponseEntity((Object)MapBuilder.immutableMapBuilder().put((Object)"timestamp", (Object)new Date()).put((Object)"status", (Object)status.value()).put((Object)"error", (Object)status.getReasonPhrase()).put((Object)"message", (Object)message).put((Object)"path", (Object)((ServletWebRequest)request).getRequest().getServletPath()).result(), status);
    }
}

