/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.errorhandling;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.unbescape.html.HtmlEscape;

public abstract class ExceptionFactory {
    public static NotFoundException notFound(Class<?> clazz, String ... paramsMap) {
        return new NotFoundException(clazz, paramsMap);
    }

    public static WebException asInternalServerException(Throwable ex) {
        return ex.getCause() instanceof WebException ? (WebException)ex.getCause() : new WebException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), ex);
    }

    public static WebException internalServerException(String message, Throwable ex) {
        return new WebException(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
    }

    public static WebException internalServerException(String message) {
        return new WebException(HttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    public static WebException badRequestException(String message) {
        return new WebException(HttpStatus.BAD_REQUEST, message);
    }

    public static WebException forbiddenException(String message) {
        return new WebException(HttpStatus.FORBIDDEN, message);
    }

    public static WebException unauthorisedException(String message) {
        return new WebException(HttpStatus.UNAUTHORIZED, message);
    }

    public static WebException conflictException(String message) {
        return new WebException(HttpStatus.CONFLICT, message);
    }

    public static WebException tooManyException(String message) {
        return new WebException(HttpStatus.TOO_MANY_REQUESTS, message);
    }

    public static void checkBadRequest(boolean condition, String message) {
        ExceptionFactory.checkBadRequest(condition, message, null);
    }

    public static <T> T checkBadRequest(boolean condition, String message, T r) {
        if (!condition) {
            throw ExceptionFactory.badRequestException(message);
        }
        return r;
    }

    static class WebException
    extends RuntimeException {
        public final HttpStatus status;

        public WebException(HttpStatus status, String message) {
            this(status, message, null);
        }

        public WebException(HttpStatus status, String message, Throwable cause) {
            super(HtmlEscape.escapeHtml4((String)message), cause);
            this.status = status;
        }
    }

    static class NotFoundException
    extends RuntimeException {
        NotFoundException(Class<?> clazz, String ... searchParamsMap) {
            super(NotFoundException.generateMessage(clazz.getSimpleName(), NotFoundException.toMap(String.class, String.class, searchParamsMap)));
        }

        private static String generateMessage(String entity, Map<String, String> searchParams) {
            return StringUtils.capitalize((String)entity) + " was not found for parameters " + searchParams;
        }

        private static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, String ... entries) {
            if (entries.length % 2 == 1) {
                throw new IllegalArgumentException("Invalid entries");
            }
            return IntStream.range(0, entries.length / 2).map(i -> i * 2).collect(LinkedHashMap::new, (m, i) -> m.put(keyType.cast(entries[i]), valueType.cast(entries[i + 1])), Map::putAll);
        }
    }
}

