/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.config.SettingsHolder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class ElasticSettings {
    String scheme = "https";
    String host = "localhost";
    int port = 9200;
    int connectTimeoutMillis = 5000;
    int socketTimeoutMillis = 300000;
    boolean insecureSsl = false;
    boolean predeterminedSsl = true;
    boolean enableSniffer = false;
    BootstrapAuth bootstrap = new BootstrapAuth();

    public ElasticSettings setBootstrap(String user, String password) {
        return this.setBootstrap(new BootstrapAuth(user, password));
    }

    Header bootstrapAuth() {
        return this.bootstrap.bootstrapAuth();
    }

    public static ElasticSettings from(SettingsHolder holder, String prefix) {
        return ElasticSettings.elasticSettings().setScheme(holder.stringValue(prefix + ".scheme", "https")).setHost(holder.stringValue(prefix + ".host", "localhost")).setPort(holder.intValue(prefix + ".port", 9200)).setConnectTimeoutMillis(holder.intValue(prefix + ".connectTimeoutMillis", 5000)).setSocketTimeoutMillis(holder.intValue(prefix + ".socketTimeoutMillis", 300000)).setInsecureSsl(holder.booleanValue(prefix + ".insecureSsl", true)).setPredeterminedSsl(holder.booleanValue(prefix + ".predeterminedSsl", true)).setEnableSniffer(holder.booleanValue(prefix + ".enableSniffer", false)).setBootstrap(holder.stringValue(prefix + ".bootstrap.username", "admin"), holder.stringValue(prefix + ".bootstrap.password", null));
    }

    public static ElasticSettings from(String url, boolean insecureSsl, boolean predeterminedSsl) {
        URI uri = URI.create(url);
        return ElasticSettings.elasticSettings().setScheme(uri.getScheme()).setHost(uri.getHost()).setPort(uri.getPort()).setInsecureSsl(insecureSsl).setPredeterminedSsl(predeterminedSsl);
    }

    public static ElasticSettings elasticSettings() {
        return new ElasticSettings();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public boolean isInsecureSsl() {
        return this.insecureSsl;
    }

    public boolean isPredeterminedSsl() {
        return this.predeterminedSsl;
    }

    public boolean isEnableSniffer() {
        return this.enableSniffer;
    }

    public BootstrapAuth getBootstrap() {
        return this.bootstrap;
    }

    public ElasticSettings setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public ElasticSettings setHost(String host) {
        this.host = host;
        return this;
    }

    public ElasticSettings setPort(int port) {
        this.port = port;
        return this;
    }

    public ElasticSettings setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public ElasticSettings setSocketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this;
    }

    public ElasticSettings setInsecureSsl(boolean insecureSsl) {
        this.insecureSsl = insecureSsl;
        return this;
    }

    public ElasticSettings setPredeterminedSsl(boolean predeterminedSsl) {
        this.predeterminedSsl = predeterminedSsl;
        return this;
    }

    public ElasticSettings setEnableSniffer(boolean enableSniffer) {
        this.enableSniffer = enableSniffer;
        return this;
    }

    public ElasticSettings setBootstrap(BootstrapAuth bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public static class BootstrapAuth {
        String username = "elastic";
        String password = null;

        Header bootstrapAuth() {
            return this.username == null || this.password == null ? null : new BasicHeader("Authorization", Base64.encodeBase64String((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8)));
        }

        public BootstrapAuth() {
        }

        public BootstrapAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public BootstrapAuth setUsername(String username) {
            this.username = username;
            return this;
        }

        public BootstrapAuth setPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

