package io.polyglotted.elastic.client;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.HttpRequestBuilder.HttpReqType;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public interface ElasticClient extends Closeable {
    void close();

    Header bootstrapAuth();

    default ElasticClient waitForYellow() { return waitForStatus("yellow"); }

    default ElasticClient waitForStatus(String status) { return waitForStatus(bootstrapAuth(), status); }

    ElasticClient waitForStatus(Header auth, String status);

    default MapResult clusterHealth() { return clusterHealth(bootstrapAuth()); }

    MapResult clusterHealth(Header auth);

    default boolean indexExists(String index) { return indexExists(bootstrapAuth(), index); }

    boolean indexExists(Header auth, String index);

    default MapResult indexNameFor(String alias) { return indexNameFor(bootstrapAuth(), alias); }

    MapResult indexNameFor(Header auth, String alias);

    default String createIndex(String indexName, String indexFile) { return createIndex(bootstrapAuth(), indexName, indexFile); }

    String createIndex(Header auth, String index, String body);

    default void dropIndex(String index) { dropIndex(bootstrapAuth(), index); }

    void dropIndex(Header auth, String index);

    default void openIndex(String index) { openIndex(bootstrapAuth(), index); }

    void openIndex(Header auth, String index);

    default void closeIndex(String index) { closeIndex(bootstrapAuth(), index); }

    void closeIndex(Header auth, String index);

    default void forceRefresh(String index) { forceRefresh(bootstrapAuth(), index); }

    void forceRefresh(Header auth, String index);

    default void putSettings(String index, String settingsJson) { putSettings(bootstrapAuth(), index, settingsJson); }

    void putSettings(Header auth, String index, String settingsJson);

    default MapResult getSettings(String index) { return getSettings(bootstrapAuth(), index); }

    MapResult getSettings(Header auth, String index);

    default void putMapping(String index, String mappingJson) { putMapping(bootstrapAuth(), index, mappingJson); }

    void putMapping(Header auth, String index, String mappingJson);

    default MapResult getMapping(String index) { return getMapping(bootstrapAuth(), index); }

    MapResult getMapping(Header auth, String index);

    default void putAliases(String aliasesJson) { putAliases(bootstrapAuth(), aliasesJson); }

    void putAliases(Header auth, String aliasesJson);

    default MapResult getAlias(String alias) { return getMapping(bootstrapAuth(), alias); }

    MapResult getAlias(Header auth, String alias);

    default void putPipeline(String id, String resource) { putPipeline(bootstrapAuth(), id, resource); }

    void putPipeline(Header auth, String id, String resource);

    default boolean pipelineExists(String id) { return pipelineExists(bootstrapAuth(), id); }

    boolean pipelineExists(Header auth, String id);

    default void deletePipeline(String id) { deletePipeline(bootstrapAuth(), id); }

    void deletePipeline(Header auth, String id);

    default void putTemplate(String name, String body) { putTemplate(bootstrapAuth(), name, body); }

    void putTemplate(Header auth, String name, String body);

    default boolean templateExists(String name) { return templateExists(bootstrapAuth(), name); }

    boolean templateExists(Header auth, String name);

    default void deleteTemplate(String name) { deleteTemplate(bootstrapAuth(), name); }

    void deleteTemplate(Header auth, String name);

    String simpleGet(Header auth, String endpoint, String methodName);

    String simplePost(Header auth, String endpoint, String body, String methodName);

    String simplePut(Header auth, String endpoint, String body, String methodName);

    void simpleDelete(Header auth, String endpoint, String methodName);

    String performCliRequest(Header auth, HttpReqType method, String endpoint) throws IOException;

    String performCliRequest(Header auth, HttpReqType method, String endpoint,
                             Map<String, String> params, HttpEntity entity) throws IOException;
}