/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.HttpRequestBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public interface ElasticClient
extends Closeable {
    @Override
    public void close();

    public Header bootstrapAuth();

    default public ElasticClient waitForYellow() {
        return this.waitForStatus("yellow");
    }

    default public ElasticClient waitForStatus(String status) {
        return this.waitForStatus(this.bootstrapAuth(), status);
    }

    public ElasticClient waitForStatus(Header var1, String var2);

    default public MapResult clusterHealth() {
        return this.clusterHealth(this.bootstrapAuth());
    }

    public MapResult clusterHealth(Header var1);

    default public boolean indexExists(String index) {
        return this.indexExists(this.bootstrapAuth(), index);
    }

    public boolean indexExists(Header var1, String var2);

    default public MapResult indexNameFor(String alias) {
        return this.indexNameFor(this.bootstrapAuth(), alias);
    }

    public MapResult indexNameFor(Header var1, String var2);

    default public String createIndex(String indexName, String indexFile) {
        return this.createIndex(this.bootstrapAuth(), indexName, indexFile);
    }

    public String createIndex(Header var1, String var2, String var3);

    default public void dropIndex(String index) {
        this.dropIndex(this.bootstrapAuth(), index);
    }

    public void dropIndex(Header var1, String var2);

    default public void forceRefresh(String index) {
        this.forceRefresh(this.bootstrapAuth(), index);
    }

    public void forceRefresh(Header var1, String var2);

    default public void putSettings(String index, String settingsJson) {
        this.putSettings(this.bootstrapAuth(), index, settingsJson);
    }

    public void putSettings(Header var1, String var2, String var3);

    default public MapResult getSettings(String index) {
        return this.getSettings(this.bootstrapAuth(), index);
    }

    public MapResult getSettings(Header var1, String var2);

    default public void putMapping(String index, String mappingJson) {
        this.putMapping(this.bootstrapAuth(), index, mappingJson);
    }

    public void putMapping(Header var1, String var2, String var3);

    default public MapResult getMapping(String index) {
        return this.getMapping(this.bootstrapAuth(), index);
    }

    public MapResult getMapping(Header var1, String var2);

    default public void putPipeline(String id, String resource) {
        this.putPipeline(this.bootstrapAuth(), id, resource);
    }

    public void putPipeline(Header var1, String var2, String var3);

    default public boolean pipelineExists(String id) {
        return this.pipelineExists(this.bootstrapAuth(), id);
    }

    public boolean pipelineExists(Header var1, String var2);

    default public void deletePipeline(String id) {
        this.deletePipeline(this.bootstrapAuth(), id);
    }

    public void deletePipeline(Header var1, String var2);

    default public void putTemplate(String name, String body) {
        this.putTemplate(this.bootstrapAuth(), name, body);
    }

    public void putTemplate(Header var1, String var2, String var3);

    default public boolean templateExists(String name) {
        return this.templateExists(this.bootstrapAuth(), name);
    }

    public boolean templateExists(Header var1, String var2);

    default public void deleteTemplate(String name) {
        this.deleteTemplate(this.bootstrapAuth(), name);
    }

    public void deleteTemplate(Header var1, String var2);

    public String simpleGet(Header var1, String var2, String var3);

    public String simplePut(Header var1, String var2, String var3, String var4);

    public void simpleDelete(Header var1, String var2, String var3);

    public String performCliRequest(Header var1, HttpRequestBuilder.HttpReqType var2, String var3) throws IOException;

    public String performCliRequest(Header var1, HttpRequestBuilder.HttpReqType var2, String var3, Map<String, String> var4, HttpEntity var5) throws IOException;
}

