/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.HttpRequestBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.common.util.ThreadUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.ElasticException;
import io.polyglotted.elastic.client.ElasticSettings;
import io.polyglotted.elastic.client.InternalHostsSniffer;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.Sniffer;

public class ElasticRestClient
implements ElasticClient {
    private final RestClient internalClient;
    private final Sniffer sniffer;
    @Nullable
    private final AuthHeader bootstrapAuth;

    ElasticRestClient(RestClientBuilder builder, ElasticSettings settings, @Nullable AuthHeader bootstrapAuth) {
        this.internalClient = builder.build();
        this.sniffer = settings.enableSniffer ? InternalHostsSniffer.buildSniffer(this.internalClient, settings, bootstrapAuth) : null;
        this.bootstrapAuth = bootstrapAuth;
    }

    @Override
    public void close() {
        if (this.sniffer != null) {
            this.sniffer.close();
        }
        this.internalClient.close();
    }

    @Override
    public ElasticClient waitForStatus(AuthHeader auth, String status) {
        try {
            int i = 0;
            if (i <= 300) {
                this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, "/_cluster/health?wait_for_status=" + status);
            }
        }
        catch (ConnectException | ConnectionClosedException retry) {
            ThreadUtil.safeSleep((long)1000L);
            this.waitForStatus(auth, status);
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("waitForStatus failed", ioe);
        }
        return this;
    }

    @Override
    public MapResult clusterHealth(AuthHeader auth) {
        return BaseSerializer.deserialize((String)this.simpleGet(auth, "/_cluster/health", "clusterHealth"));
    }

    @Override
    public boolean indexExists(AuthHeader auth, String index) {
        try {
            return this.internalClient.performRequest("HEAD", "/" + index, this.headers(auth)).getStatusLine().getStatusCode() == 200;
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("indexExists failed", ioe);
        }
    }

    @Override
    public MapResult indexNameFor(AuthHeader auth, String alias) {
        MapBuilder.ImmutableMapBuilder result = MapBuilder.immutableMapBuilder();
        try {
            List list = BaseSerializer.deserializeToList((String)this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, "/_cat/aliases" + (StrUtil.notNullOrEmpty((String)alias) ? "/" + alias : "") + "?h=index,alias&format=json"));
            for (Map map : list) {
                result.put((Object)MapRetriever.reqdStr((Map)map, (String)"alias"), (Object)MapRetriever.reqdStr((Map)map, (String)"index"));
            }
            return result.result();
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("indexNameFor failed", ioe);
        }
    }

    @Override
    public String createIndex(AuthHeader auth, String index, String body) {
        try {
            MapResult result = BaseSerializer.deserialize((String)this.simplePut(auth, "/" + index, body, "createIndex"));
            ElasticException.checkState(result.boolVal("acknowledged", false) && result.boolVal("shards_acknowledged", false), "unable to create index");
            return result.reqdStr("index");
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("createIndex failed", ioe);
        }
    }

    @Override
    public void dropIndex(AuthHeader auth, String index) {
        this.simpleDelete(auth, "/" + index, "dropIndex");
    }

    @Override
    public void forceRefresh(AuthHeader auth, String index) {
        try {
            this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.POST, "/" + index + "/_refresh");
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("forceRefresh failed", ioe);
        }
    }

    @Override
    public void putSettings(AuthHeader auth, String index, String settingsJson) {
        try {
            this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.POST, "/" + index + "/_close");
            this.simplePut(auth, "/" + index + "/_settings", settingsJson, "putSettings");
            this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.POST, "/" + index + "/_open");
        }
        catch (Exception e) {
            throw ElasticException.throwEx("putSettings failed", e);
        }
    }

    @Override
    public MapResult getSettings(AuthHeader auth, String index) {
        try {
            MapResult result = BaseSerializer.deserialize((String)this.simpleGet(auth, "/" + index + "/_settings", "getSettings"));
            return MapResult.immutableResult((Map)((Map)MapRetriever.deepRetrieve((Object)MapRetriever.asMap((Object)result.first()), (String)"settings.index")));
        }
        catch (Exception e) {
            throw ElasticException.throwEx("getSettings failed", e);
        }
    }

    @Override
    public void putMapping(AuthHeader auth, String index, String mappingJson) {
        this.simplePut(auth, "/" + index + "/_mapping/_doc", mappingJson, "putMapping");
    }

    @Override
    public MapResult getMapping(AuthHeader auth, String index) {
        try {
            MapResult result = BaseSerializer.deserialize((String)this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, "/" + index + "/_mapping/_doc"));
            return MapResult.immutableResult((Map)MapRetriever.mapVal((Map)MapRetriever.asMap((Object)result.first()), (String)"mappings"));
        }
        catch (Exception e) {
            throw ElasticException.throwEx("getMapping failed", e);
        }
    }

    @Override
    public void putPipeline(AuthHeader auth, String id, String body) {
        this.simplePut(auth, "/_ingest/pipeline/" + id, body, "putPipeline");
    }

    @Override
    public boolean pipelineExists(AuthHeader auth, String id) {
        return this.simpleGet(auth, "/_ingest/pipeline/" + id, "pipelineExists") != null;
    }

    @Override
    public void deletePipeline(AuthHeader auth, String id) {
        this.simpleDelete(auth, "/_ingest/pipeline/" + id, "deletePipeline");
    }

    @Override
    public void putTemplate(AuthHeader auth, String name, String body) {
        this.simplePut(auth, "/_template/" + name, body, "putTemplate");
    }

    @Override
    public boolean templateExists(AuthHeader auth, String name) {
        return this.simpleGet(auth, "/_template/" + name, "templateExists") != null;
    }

    @Override
    public void deleteTemplate(AuthHeader auth, String name) {
        this.simpleDelete(auth, "/_template/" + name, "deleteTemplate");
    }

    @Override
    public String simpleGet(AuthHeader auth, String endpoint, String methodName) {
        Throwable throwable;
        try {
            return this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, endpoint);
        }
        catch (ResponseException re) {
            if (re.getResponse().getStatusLine().getStatusCode() == 404) {
                return null;
            }
            throwable = re;
        }
        catch (Exception ioe) {
            throwable = ioe;
        }
        throw ElasticException.throwEx(methodName + " failed", throwable);
    }

    @Override
    public String simplePut(AuthHeader auth, String endpoint, String body, String methodName) {
        try {
            return this.performCliRequest(HttpRequestBuilder.HttpReqType.PUT, endpoint, Collections.emptyMap(), (HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON), this.headers(auth));
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx(methodName + " failed", ioe);
        }
    }

    @Override
    public void simpleDelete(AuthHeader auth, String endpoint, String methodName) {
        try {
            this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.DELETE, endpoint);
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx(methodName + " failed", ioe);
        }
    }

    @Override
    public String performCliRequest(AuthHeader auth, HttpRequestBuilder.HttpReqType method, String endpoint) throws IOException {
        return this.performCliRequest(method, endpoint, Collections.emptyMap(), null, this.headers(auth));
    }

    @Override
    public String performCliRequest(HttpRequestBuilder.HttpReqType method, String endpoint, Map<String, String> params, HttpEntity entity, Header ... headers) throws IOException {
        Response response = this.internalClient.performRequest(method.name(), endpoint, params, entity, headers);
        int statusCode = response.getStatusLine().getStatusCode();
        ElasticException.checkState(statusCode >= 200 && statusCode < 300, response.getStatusLine().getReasonPhrase());
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    private Header[] headers(AuthHeader authHeader) {
        return authHeader != null ? authHeader.headers() : (this.bootstrapAuth != null ? this.bootstrapAuth.headers() : new Header[]{});
    }

    @Override
    @Nullable
    public AuthHeader bootstrapAuth() {
        return this.bootstrapAuth;
    }
}

