/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.HttpRequestBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public interface ElasticClient
extends Closeable {
    @Override
    public void close();

    public AuthHeader bootstrapAuth();

    default public ElasticClient waitForYellow() {
        return this.waitForStatus("yellow");
    }

    default public ElasticClient waitForStatus(String status) {
        return this.waitForStatus(this.bootstrapAuth(), status);
    }

    public ElasticClient waitForStatus(AuthHeader var1, String var2);

    default public MapResult clusterHealth() {
        return this.clusterHealth(this.bootstrapAuth());
    }

    public MapResult clusterHealth(AuthHeader var1);

    default public boolean indexExists(String index) {
        return this.indexExists(this.bootstrapAuth(), index);
    }

    public boolean indexExists(AuthHeader var1, String var2);

    default public MapResult indexNameFor(String alias) {
        return this.indexNameFor(this.bootstrapAuth(), alias);
    }

    public MapResult indexNameFor(AuthHeader var1, String var2);

    default public String createIndex(String indexName, String indexFile) {
        return this.createIndex(this.bootstrapAuth(), indexName, indexFile);
    }

    public String createIndex(AuthHeader var1, String var2, String var3);

    default public void dropIndex(String index) {
        this.dropIndex(this.bootstrapAuth(), index);
    }

    public void dropIndex(AuthHeader var1, String var2);

    default public void forceRefresh(String index) {
        this.forceRefresh(this.bootstrapAuth(), index);
    }

    public void forceRefresh(AuthHeader var1, String var2);

    default public void putSettings(String index, String settingsJson) {
        this.putSettings(this.bootstrapAuth(), index, settingsJson);
    }

    public void putSettings(AuthHeader var1, String var2, String var3);

    default public MapResult getSettings(String index) {
        return this.getSettings(this.bootstrapAuth(), index);
    }

    public MapResult getSettings(AuthHeader var1, String var2);

    default public void putMapping(String index, String mappingJson) {
        this.putMapping(this.bootstrapAuth(), index, mappingJson);
    }

    public void putMapping(AuthHeader var1, String var2, String var3);

    default public MapResult getMapping(String index) {
        return this.getMapping(this.bootstrapAuth(), index);
    }

    public MapResult getMapping(AuthHeader var1, String var2);

    default public void putPipeline(String id, String resource) {
        this.putPipeline(this.bootstrapAuth(), id, resource);
    }

    public void putPipeline(AuthHeader var1, String var2, String var3);

    default public boolean pipelineExists(String id) {
        return this.pipelineExists(this.bootstrapAuth(), id);
    }

    public boolean pipelineExists(AuthHeader var1, String var2);

    default public void deletePipeline(String id) {
        this.deletePipeline(this.bootstrapAuth(), id);
    }

    public void deletePipeline(AuthHeader var1, String var2);

    default public void putTemplate(String name, String body) {
        this.putTemplate(this.bootstrapAuth(), name, body);
    }

    public void putTemplate(AuthHeader var1, String var2, String var3);

    default public boolean templateExists(String name) {
        return this.templateExists(this.bootstrapAuth(), name);
    }

    public boolean templateExists(AuthHeader var1, String var2);

    default public void deleteTemplate(String name) {
        this.deleteTemplate(this.bootstrapAuth(), name);
    }

    public void deleteTemplate(AuthHeader var1, String var2);

    public String simpleGet(AuthHeader var1, String var2, String var3);

    public String simplePut(AuthHeader var1, String var2, String var3, String var4);

    public void simpleDelete(AuthHeader var1, String var2, String var3);

    public String performCliRequest(AuthHeader var1, HttpRequestBuilder.HttpReqType var2, String var3) throws IOException;

    public String performCliRequest(HttpRequestBuilder.HttpReqType var1, String var2, Map<String, String> var3, HttpEntity var4, Header ... var5) throws IOException;
}

