package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.HttpRequestBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public interface ElasticClient extends Closeable {
    void close();

    AuthHeader bootstrapAuth();

    default ElasticClient waitForYellow() { return waitForStatus("yellow"); }

    default ElasticClient waitForStatus(String status) { return waitForStatus(bootstrapAuth(), status); }

    ElasticClient waitForStatus(AuthHeader auth, String status);

    default MapResult clusterHealth() { return clusterHealth(bootstrapAuth()); }

    MapResult clusterHealth(AuthHeader auth);

    default boolean indexExists(String index) { return indexExists(bootstrapAuth(), index); }

    boolean indexExists(AuthHeader auth, String index);

    default MapResult indexNameFor(String alias) { return indexNameFor(bootstrapAuth(), alias); }

    MapResult indexNameFor(AuthHeader auth, String alias);

    default String createIndex(String indexName, String indexFile) { return createIndex(bootstrapAuth(), indexName, indexFile); }

    String createIndex(AuthHeader auth, String index, String body);

    default void dropIndex(String index) { dropIndex(bootstrapAuth(), index); }

    void dropIndex(AuthHeader auth, String index);

    default void forceRefresh(String index) { forceRefresh(bootstrapAuth(), index); }

    void forceRefresh(AuthHeader auth, String index);

    default void putSettings(String index, String settingsJson) { putSettings(bootstrapAuth(), index, settingsJson); }

    void putSettings(AuthHeader auth, String index, String settingsJson);

    default MapResult getSettings(String index) { return getSettings(bootstrapAuth(), index); }

    MapResult getSettings(AuthHeader auth, String index);

    default void putMapping(String index, String mappingJson) { putMapping(bootstrapAuth(), index, mappingJson); }

    void putMapping(AuthHeader auth, String index, String mappingJson);

    default MapResult getMapping(String index) { return getMapping(bootstrapAuth(), index); }

    MapResult getMapping(AuthHeader auth, String index);

    default void putPipeline(String id, String resource) { putPipeline(bootstrapAuth(), id, resource); }

    void putPipeline(AuthHeader auth, String id, String resource);

    default boolean pipelineExists(String id) { return pipelineExists(bootstrapAuth(), id); }

    boolean pipelineExists(AuthHeader auth, String id);

    default void deletePipeline(String id) { deletePipeline(bootstrapAuth(), id); }

    void deletePipeline(AuthHeader auth, String id);

    default void putTemplate(String name, String body) { putTemplate(bootstrapAuth(), name, body); }

    void putTemplate(AuthHeader auth, String name, String body);

    default boolean templateExists(String name) { return templateExists(bootstrapAuth(), name); }

    boolean templateExists(AuthHeader auth, String name);

    default void deleteTemplate(String name) { deleteTemplate(bootstrapAuth(), name); }

    void deleteTemplate(AuthHeader auth, String name);

    String simpleGet(AuthHeader auth, String endpoint, String methodName);

    String simplePut(AuthHeader auth, String endpoint, String body, String methodName);

    void simpleDelete(AuthHeader auth, String endpoint, String methodName);

    String performCliRequest(AuthHeader auth, HttpRequestBuilder.HttpReqType method, String endpoint) throws IOException;

    String performCliRequest(HttpRequestBuilder.HttpReqType method, String endpoint, Map<String, String> params,
                             HttpEntity entity, Header... headers) throws IOException;
}